"use strict";

kQuery(function($) {
    var csrf_token = Fileman.token;
    var item_checkbox_selector = '.k-js-item-select';
    var item_row_selector = '.fileman_file';
    var download_button_selector = '.k-js-multi-download';
    var download_button = $(download_button_selector);
    var download_spinner = $('<span class="k-loader" style="display: none">Loading...</span>');

    download_button.ktooltip({
        title: Koowa.translate('Preparing download'),
        placement: 'bottom',
        delay: {show: 200, hide: 50},
        trigger: 'manual',
        container: '.k-ui-namespace'
    });

    var startSpinner = function () {
        download_button.ktooltip('show');
        download_spinner.css('display', '');
    };
    var stopSpinner = function () {
        download_button.ktooltip('hide');
        download_spinner.css('display', 'none');
    };

    var enableButton = function() {
        download_button.removeClass('k-is-disabled disabled');
    };

    var disableButton = function () {
        download_button.addClass('k-is-disabled disabled');
    };
    var setButtonStatus = function(){
        var checked = $(item_checkbox_selector + ':checked');
        if(checked.length) {
            var count = 0;
            $.each(checked, function (index, checkbox) {
                var $checkbox = $(checkbox);
                count++;
            });

            if (count) {
                enableButton();
            } else {
                disableButton();
            }

        } else {
            disableButton();
        }
    };

    var isButtonEnabled = function () {
        return !download_button.hasClass('k-is-disabled');
    };

    download_button.append(download_spinner);

    setButtonStatus();

    $('body').on('click', item_checkbox_selector, setButtonStatus)
        .on('click', item_row_selector, setButtonStatus);

    download_button.on('click', function (event) {
        event.preventDefault();

        if (!isButtonEnabled()) {
            return;
        }

        var items = $(item_checkbox_selector + ':checked');

        if (items.length) {

            var ids = [];

            $.each(items, function (index, checkbox) {
                var $checkbox = $(checkbox);
                ids.push($checkbox.data('name'));
            });

            if (ids) {
                var href = download_button.attr('href');

                href += (href.indexOf('?') !== -1 ? '&' : '?');

                $.ajax({
                    method: 'post',
                    url: href+$.param({view:'download', name: ids}),
                    dataType: 'json',
                    data: {
                        _action: 'compress',
                        csrf_token: csrf_token
                    },
                    beforeSend: function () {

                        startSpinner();
                        disableButton();
                    }
                }).done(function(response) {
                    if (typeof response === 'object' && response.archive) {

                        window.location.href = href+$.param({view: 'download', archive: response.archive});

                        enableButton();
                        stopSpinner();
                    }
                }).fail(function () {
                    enableButton();
                    stopSpinner();
                });
            }

        }
    });
});