<?
/**
 * @package     FILEman
 * @copyright   Copyright (C) 2020 Timble CVBA. (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */
defined('KOOWA') or die; ?>

<?= helper('ui.load', array(
    'package' => 'fileman',
    'wrapper' => false
)); ?>

<?= helper('com:fileman.slider.load', ['options' => $params->slider_options]) ?>

<? if (count($files)): ?>
    <div class="k-ui-namespace">
        <div class="mod_fileman">
            <div class="koowa_media--slider mod_fileman--slider">
                <div class="splide__track">
                    <div class="splide__list">
                        <? foreach ($files as $file): ?>
                            <? if ($file->isImage()): ?>
                                <div class="splide__slide">
                                    <? if( $file->thumbnail ): ?>
                                        <img
                                            <? if ($params->slider_options->lazyLoad == 'nearby' ||     $params->slider_options->lazyLoad == 'sequential'): ?>
                                            data-splide-lazy="<?= $file->thumbnail->relative_path ?>"
                                            <? else: ?>
                                            src="<?= $file->thumbnail->relative_path ?>"
                                            <? endif ?>
                                            alt="<?= escape($file->display_name) ?>">
                                    <? else: ?>
                                        <div class="default-thumbnail">
                                            <span class="k-icon-document-image k-icon--size-xlarge"></span>
                                        </div>
                                    <? endif ?>
                                </div>
                            <? elseif ($file->isVideo() && $file->extension != 'avi'): ?>
                                <div class="splide__slide" data-splide-html-video="<?= helper('com://admin/fileman.route.permalink', ['file' => $file]) ?>">
                                    <div style="height: <?= !$has_image ? '20rem' : '100%' ?>; background-color: #999"></div>
                                </div>
                            <? endif ?>
                        <? endforeach ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<? else: ?>
    <p class="alert alert-info">
        <?= translate('You do not have any image or video files yet.'); ?>
    </p>
<? endif; ?>