<?php
/**
 * Copyright (c) 2006-2022 LogicalDOC
 * WebSites: www.logicaldoc.com
 * 
 * No bytes were intentionally harmed during the development of this application.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
defined('_JEXEC') or die;

use logicaldoc\LDOCWebServicesFactory;
use logicaldoc\LDOCWebservice10;

use \Swagger\Client\Model\WSDocument;

require_once (JPATH_COMPONENT . DS . 'IconSelector.php');
?>
<script type="text/javascript">

    $(document).ready(function() {
    var iDisplayLength = <?php echo $this->rowConfiguration->showEntries; ?>;
            var icon = <?php echo $this->rowConfiguration->icon; ?>;
            var size = <?php echo $this->rowConfiguration->size; ?>;
            var updateDate = <?php echo $this->rowConfiguration->updateDate; ?>;
            var author = <?php echo $this->rowConfiguration->author; ?>;
            var version = <?php echo $this->rowConfiguration->version; ?>;
            var iconValor = false;
            var sizeValor = false;
            var updateDateValor = false;
            var authorValor = false;
            var versionValor = false;
            if (icon == 1) {
    iconValor = true;
    }
    if (size === 1) {
	sizeValor = true;
    }
    if (updateDate == 1) {
    updateDateValor = true;
    }
    if (author == 1) {
    authorValor = true;
    }
    if (version == 1) {
    versionValor = true;
    }
    $('#tablaSearch').dataTable({
    "processing":true,
            //"serverSide": true,
            "iDisplayLength": iDisplayLength,
            "bFilter": true,
            "scrollX": true,
            //"ajax": "index.php?option=com_logicaldoc&view=search&task=pagination&format=json&id=<?php echo $this->rowConfiguration->idConfiguration; ?>",
            "aoColumns": [
            {"bSortable": false, "bSearchable": false, "bVisible": iconValor},
            {"bSortable": true, "bVisible": true},
			{"bSortable": true, "bVisible": sizeValor,
				"mRender": function(size, type, full) {
							if (type == 'display') {
								if (size === '0') {return '0 B';}
								if (size == 0) {return ' ';}
								var sizek = Math.floor( size / 1024 ).toFixed(0) * 1;
								return sizek.toLocaleString() + ' kB';
							}
						return size;
					}
      		},			
            {"bSortable": true, "bVisible": updateDateValor,
						"mRender": function(date, type, full) {
										if (type == 'display') {
											var mydt = new Date(date);
											return mydt.toLocaleDateString() + " " + mydt.toLocaleTimeString();
								  		}
		                              return date;
		                           }			
			},
            {"bSortable": true, "bVisible": authorValor},
            {"bSortable": false, "bVisible": versionValor}
<?php for ($i = 0; $i < count($this->rowsMetadata); $i++) { ?>
                , {"bSortable": false, "bVisible": true}
<?php } ?>
            ],
            "aaSorting": [[0, "asc"]],
            "oLanguage": {
            "sProcessing": "<?php echo JText::_('COM_LOGICALDOC_PLEASE_WAIT') ?>",
                    "sLengthMenu": "<?php echo JText::_('COM_LOGICALDOC_SHOW') ?>_MENU_ <?php echo JText::_('COM_LOGICALDOC_ENTRIES') ?>",
                                        "sZeroRecords": "<?php echo JText::_('COM_LOGICALDOC_NOTHING_FOUND_SORRY') ?>",
                                        "sInfo": "<?php echo JText::_('COM_LOGICALDOC_SHOWING') ?>_START_ <?php echo JText::_('COM_LOGICALDOC_TO') ?> _END_ <?php echo JText::_('COM_LOGICALDOC_OF') ?> _TOTAL_ <?php echo JText::_('COM_LOGICALDOC_ENTRIES') ?>",
                                                            "sInfoEmpty": "<?php echo JText::_('COM_LOGICALDOC_SHOWING') ?> 0 <?php echo JText::_('COM_LOGICALDOC_TO') ?> 0 <?php echo JText::_('COM_LOGICALDOC_OF') ?> 0 <?php echo JText::_('COM_LOGICALDOC_ENTRIES') ?>",
                                                                                "sInfoFiltered": "(<?php echo JText::_('COM_LOGICALDOC_FILTERED_FROM') ?> _MAX_ <?php echo JText::_('COM_LOGICALDOC_TOTAL_ENTRIES') ?>)",
                                                                                "sInfoPostFix": "",
                                                                                "sSearch": "<?php echo JText::_('COM_LOGICALDOC_SEARCH'); ?>",
                                                                                "sUrl": "",
                                                                                "oPaginate": {
                                                                                "sFirst": "<?php echo JText::_('COM_LOGICALDOC_FIRST') ?>",
                                                                                        "sPrevious": "<?php echo JText::_('COM_LOGICALDOC_PREVIOUS') ?>",
                                                                                        "sNext": "<?php echo JText::_('COM_LOGICALDOC_NEXT') ?>",
                                                                                        "sLast": "<?php echo JText::_('COM_LOGICALDOC_LAST') ?>"
                                                                                }
                                                                        }
                                                                });
                                                                });
</script>
<style type="text/css">
    #advanced{
        margin-top:10px;
        margin-bottom:10px;
    }
</style>
<?php

function optionLabel($options) {
    foreach ($options as $option) {
        if ($option->isSelected() == 'true') {
            return $option->getLabel();
        }
    }
}

function optionValue($options) {
    foreach ($options as $option) {
        if ($option->isSelected() == 'true') {
            return $option->getValue();
        }
    }
}

function printFolder(Folder $folder, LDOCWebservice10 $ws, $rowsMetadata) {
    ?>
    <tr>
        <td align="center">
            <img src="components/com_logicaldoc/assets/images/menuitem_childs.png" />             
        </td>
        <td style="white-space: nowrap;">
            <a  href="index.php?option=com_logicaldoc&view=desktop&layout=view&enter=1&uuid=<?php echo $folder->getUuid(); ?>" >
                <?php
                echo substr($folder->getPath(), strrpos($folder->getPath(), '/') + 1);
                ?>
            </a>
        </td>
        <td>

        </td>
        <td style="white-space: nowrap;">            
            <?php
            $time = strtotime($folder->getCreated());
            echo date('d/m/Y h:i:s', $time);
            ?>
        </td>
        <td style="white-space: nowrap;">
            <?php echo $folder->getAuthor(); ?>
        </td>
        <td>           
        </td> 
        <?php
        if (!empty($rowsMetadata)) {

            $property = explode(".", $rowsMetadata[0]->property);
            $group = str_replace("okp", "okg", $property[0]);
            $formElements = $ws->getPropertyGroupProperties($folder->getUuid(), $group);

            foreach ($rowsMetadata as $rowMetadata) {
                ?>
                <td style="white-space: nowrap;">
                    <?php
                    foreach ($formElements as $formElement) {
                        if ($formElement instanceof Input) {
                            $name = $formElement->getName();
                            $value = $formElement->getValue();
                            if ($rowMetadata->property == $name) {
                                echo $value;
                            }
                        } else if ($formElement instanceof Select) {
                            $name = $formElement->getName();
                            if ($rowMetadata->property == $name) {
                                echo optionLabel($formElement->getOptions());
                            }
                        } else if ($formElement instanceof TextArea) {
                            $name = $formElement->getName();
                            $value = $formElement->getValue();
                            if ($rowMetadata->property == $name) {
                                echo $value;
                            }
                        } else if ($formElement instanceof CheckBox) {
                            $name = $formElement->getName();
                            $value = $formElement->isValue();
                            if ($rowMetadata->property == $name) {
                                echo $value;
                            }
                        }
                    }
                    ?>
                </td>
                <?php
            }
        }
        ?>
    </tr>
    <?php
}

function printDocument(WSDocument $document, $rowConfiguration, LDOCWebservice10 $ws, $rowsMetadata) {
    ?>
    <tr>
        <td align="center">
            <img src="components/com_logicaldoc/assets/mimes/<?php echo IconSelector::selectIcon($document->getType()); ?>" />            
        </td>
        <td style="white-space: nowrap;">            
            <a  href="index.php?option=com_logicaldoc&view=desktop&task=download&format=raw&uuid=<?php echo $document->getId(); ?>&id=<?php echo $rowConfiguration->idConfiguration; ?>" >                
                <?php echo $document->getFileName(); ?>
            </a>               
        </td>
        <td style="white-space: nowrap;">
            <?php echo $document->getFileSize(); ?>
        </td>
        <td style="white-space: nowrap;">
            <?php
            //$time = strtotime($document->getCreated());
            //echo date('d/m/Y h:i:s', $time);
			$ymd = DateTime::createFromFormat('Y-m-d H:i:s O', $document->getDate());
			echo $ymd->format('c');				
            ?>
        </td>
        <td style="white-space: nowrap;">
            <?php echo $document->getCreator(); ?>
        </td>
        <td style="white-space: nowrap;">
            <?php echo $document->getVersion(); ?>
        </td>
        <?php
        if (!empty($rowsMetadata)) {

            $property = explode(".", $rowsMetadata[0]->property);
            $group = str_replace("okp", "okg", $property[0]);
            $formElements = $ws->getPropertyGroupProperties($document->getUuid(), $group);

            foreach ($rowsMetadata as $rowMetadata) {
                ?>
                <td style="white-space: nowrap;">
                    <?php
                    foreach ($formElements as $formElement) {
                        if ($formElement instanceof Input) {
                            $name = $formElement->getName();
                            $value = $formElement->getValue();
                            if ($rowMetadata->property == $name) {
                                echo $value;
                            }
                        } else if ($formElement instanceof Select) {
                            $name = $formElement->getName();
                            if ($rowMetadata->property == $name) {
                                echo optionLabel($formElement->getOptions());
                            }
                        } else if ($formElement instanceof TextArea) {
                            $name = $formElement->getName();
                            $value = $formElement->getValue();
                            if ($rowMetadata->property == $name) {
                                echo $value;
                            }
                        } else if ($formElement instanceof CheckBox) {
                            $name = $formElement->getName();
                            $value = $formElement->isValue();
                            if ($rowMetadata->property == $name) {
                                echo $value;
                            }
                        }
                    }
                    ?>
                </td>
                <?php
            }
        }
        ?>
    </tr>
    <?php
}

function redondear($numero, $decimales) {
    $factor = pow(10, $decimales);
    return (round($numero * $factor) / $factor);
}

function formatSize($size) {
    $srt = "BIG";
    if ($size / 1024 < 1) {
        $srt = $size . " byte";
    } else if ($size / 1048576 < 1) {
        $srt = redondear(($size / 1024), 1) . " kB";
    } else if ($size / 1073741824 < 1) {
        $srt = redondear(($size / 1048576), 1) . " MB";
    } else if ($size / 1099511627776 < 1) {
        $srt = redondear(($size / 1073741824), 1) . " GB";
    }
    return $srt;
}


if ($this->error == 0) {
    ?>    
    <div id="advanced">
        <?php require_once ('form.php'); ?>
    </div>
    <table id="tablaSearch" width="100%" class="display" cellpadding="0" cellspacing="0" border="0">
        <thead>
            <tr>
                <th > </th>
                <th > <?php echo JText::_('COM_LOGICALDOC_NAME') ?></th>
                <th > <?php echo JText::_('COM_LOGICALDOC_SIZE') ?></th>
                <th style="white-space: nowrap;"> <?php echo JText::_('COM_LOGICALDOC_UPDATE_DATE') ?></th>
                <th > <?php echo JText::_('COM_LOGICALDOC_AUTHOR') ?></th>
                <th > <?php echo JText::_('COM_LOGICALDOC_VERSION') ?></th>
                <?php foreach ($this->rowsMetadata as $rowMetadata) { ?>
                        <th style="white-space: nowrap;"><?php echo $rowMetadata->title; ?></th>
                <?php } ?>
            </tr>
        </thead>
        <tbody>
            <?php
            $ws = LDOCWebServicesFactory::build($this->rowConfiguration->url, $this->rowConfiguration->user, $this->rowConfiguration->password);
            //error_log(print_r($this->results, true));			
            
			/*
            foreach ($this->results->getHits() as $queryResult) {
                    if ($queryResult->getDocument() != null) {                        
                        printDocument($queryResult->getDocument(), $this->rowConfiguration,$ws,$this->rowsMetadata);
                    } else if ($queryResult->getFolder() != null) {
                        printFolder($queryResult->getFolder(),$ws,$this->rowsMetadata);                        
                    }   
            } */    

			if (!empty($this->resultArray)) {
				//echo "!empty(this->resultArray";
				
                if (is_array($this->resultArray)) {
					
					//echo "is_array(this->resultArray)";
                    foreach ($this->resultArray as $wsdocument) {
						printDocument($wsdocument, $this->rowConfiguration,$ws,$this->rowsMetadata);
                    }
                } else {
					printDocument($this->resultArray, $this->rowConfiguration,$ws,$this->rowsMetadata);
                }
            }
            ?>
        </tbody>
    </table>

<?php } else { ?>   
    <h2><?php echo JText::_('COM_LOGICALDOC_ERROR_THE_CONFIGURATION_IS_NOT_CORRECT_PLEASE_CHECK_YOUR_LOGICALDOC_CONFIGURATION_TO_CONNECTO_TO') ?>.</h2>
    <p>
        <?= $this->ldocMessage; ?>
    </p>
    <?php
} 