<?php

/**
 * Copyright (c) 2006-2022 LogicalDOC
 * WebSites: www.logicaldoc.com
 * 
 * No bytes were intentionally harmed during the development of this application.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.controller');

class LogicalDOCControllerDesktop extends JControllerLegacy {

    public function display($cachable = false, $urlparams = false) {
        parent::display($cachable, $urlparams);
    }

    public function folder(){
        $enter = 1;
        JRequest::setVar('view', 'desktop');
        JRequest::setVar('layout', 'view');        
        JRequest::setVar('enter', $enter);
        $this->display(); 
    }
    
    public function send() {
        require_once (JPATH_COMPONENT . DS . 'tables' . DS . 'configuration.php');
        $rowConfiguration = JTable::getInstance('Configuration', 'Table');
        $id = JRequest::getVar('id');
        $rowConfiguration->load($id);
        $passwordAccess = $rowConfiguration->passwordAccess;
        $acceder = JRequest::getVar('passwordAccess');
        $enter = 0;
        $message = JText::_('COM_LOGICALDOC_INCORRECT_PASSWORD');
        if (substr_compare($passwordAccess, $acceder, 0) == 0) {
            $enter = 1;
            $message = JText::_('COM_LOGICALDOC_CORRECT_PASSWORD');
        }
        JRequest::setVar('view', 'desktop');
        JRequest::setVar('layout', 'view');
        JRequest::setVar('enter', $enter);
        JRequest::setVar('message',$message);
        $this->display();
    }

    public function download() {
        JRequest::setVar('view', 'desktop');
        JRequest::setVar('layout', 'download');
        JRequest::setVar('format','raw');
        JRequest::setVar('uuid',  JRequest::getVar('uuid')); 
        JRequest::setVar('id', JRequest::getVar('id'));
        $this->display();
    }

    public function searchBasic() {
        JRequest::setVar('view', 'search');
        JRequest::setVar('layout', 'result');
        JRequest::setVar('content', JRequest::getVar('content'));
        JRequest::setVar('document', JRequest::getVar('document'));
        JRequest::setVar('folder', JRequest::getVar('folder'));
        $this->display();
    }

    public function returnDesktop() {
        JRequest::setVar('view', 'desktop');
        JRequest::setVar('layout', 'view');
        $enter = 1;
        JRequest::setVar('enter', $enter);
        $this->display();
    }

}

?>
