<?php

/**
 * Copyright (c) 2006-2022 LogicalDOC
 * WebSites: www.logicaldoc.com
 * 
 * No bytes were intentionally harmed during the development of this application.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
defined('_JEXEC') or die;

use logicaldoc\LDOCWebServicesFactory;
use Swagger\Client\Model\WSFolder;

jimport('joomla.application.component.view');

class LogicalDOCViewDesktop extends JViewLegacy {

    public $ws;

    public function display($tpl = null) {

        $layout = JRequest::getVar('layout');
        $app = JFactory::getApplication();
        $params = $app->getParams();
        $name = $params->get('name');

        require_once(JPATH_COMPONENT . DS . 'models' . DS . 'configuration.php');
        $modelConfiguration = new LogicalDOCModelConfiguration();
        $rowsCongiguration = $modelConfiguration->getObject($name);
        $rowConfiguration = $rowsCongiguration[0];        
        $access = $rowConfiguration->access;
        $ldocPath = $rowConfiguration->ldocPath;
        $this->assignRef('rowConfiguration', $rowConfiguration);
        
        //Metadata
        require_once (JPATH_COMPONENT . DS . 'models' . DS . 'metadata.php');
        $modelMetadata = new LogicalDOCModelMetadata();
        $rowsMetadata = $modelMetadata->getObjects($rowConfiguration->idConfiguration);
        $this->assignRef('rowsMetadata', $rowsMetadata);
        
        $error = 0;
        $enter = 0;

        if ($layout == 'view') {
            if ($access == 'Private') {
                $enter = JRequest::getVar("enter");
                if ($enter == null) {
                    $enter = 0;
                }
            } else {
                $enter = 1;
            }
            if ($enter == 1) {
                try {
                    $this->ws = LDOCWebServicesFactory::build($rowConfiguration->url, $rowConfiguration->user, $rowConfiguration->password);                                                            
                    $uuid = JRequest::getVar('uuid');
					//error_log("uuid: $uuid");
                    //$folder = new Folder();                    
					$folder = new WSFolder();                    
                    if(empty($uuid)){
						//error_log("ldocPath: $ldocPath");
                        $folder = $this->ws->getFolderProperties($ldocPath);    						
                        $breadcrumbs = array();
                        //$breadcrumbs[$folder->getUuid()] = $folder->getPath();
						//$breadcrumbs[$folder->getId()] = $folder->getPath();
						$breadcrumbs[$folder->getId()] = $folder->getName();
                        $session = JFactory::getSession();
                        $session->set('breadcrumbs', $breadcrumbs);
                    }
                    else {
						//error_log("uuid2: $uuid");
                        $folder = $this->ws->getFolderProperties($uuid);
                        $addPath = JRequest::getVar('addPath');
                        $session = JFactory::getSession();
                        $breadcrumbs = $session->get('breadcrumbs');
                        if ($addPath != 1) {
                            //$breadcrumbs[$folder->getUuid()] = $folder->getPath();
							//$breadcrumbs[$folder->getId()] = $folder->getPath();
							$breadcrumbs[$folder->getId()] = $folder->getName();
                            $session->set('breadcrumbs', $breadcrumbs);
                        } else {
                            $copy = array();
                            foreach ($breadcrumbs as $uuid => $path){
                                //if($folder->getUuid() == $uuid){                                    
								if($folder->getId() == $uuid){
                                    $copy[$uuid] = $path;
                                    break;
                                }else {
                                    $copy[$uuid] = $path;
                                }
                            }                            
                            $session->set('breadcrumbs', $copy);
                        }
                    }                                        
                    //$documents = $this->ws->getDocumentChildren($folder->getUuid());
					$documents = $this->ws->getDocumentChildren($folder->getId());
                    //$folders = $this->ws->getFolderChildren($folder->getUuid());                    
					$folders = $this->ws->getFolderChildren($folder->getId());
                    $this->assignRef('documents', $documents);
                    $this->assignRef('folders', $folders);                    
                    $this->assignRef('ws',$this->ws);
                    $this->assignRef('error', $error);
                    $this->assignRef('session', $session);
                } catch (Exception $e) {
                    $error = 1;
                    $this->assignRef('error', $error);
                }
            }
            $message = JRequest::getVar('message');
            $this->assignRef('message', $message);
            $this->assignRef('enter', $enter);
        } 
        parent::display($tpl);
    }

}

?>
