/**
 * @package     FILEman
 * @copyright   Copyright (C) 2011 Timble CVBA. (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

!function ($) {

    if(!this.Fileman) this.Fileman = {};

    Fileman.trackEvent = function(options) {
        options = $.extend({
            category: 'FILEman',
            action: 'View',
            label: null,
            value: null,
            noninteraction: false
        }, options);

        if (typeof _gaq !== 'undefined' && _gat._getTrackers().length) {
            _gaq.push(function() {
                var tracker = _gat._getTrackers()[0];
                tracker._trackEvent(options.category, options.action, options.label, options.value, options.noninteraction);
            });
        }
    };

    Fileman.isMobile = function()
    {
        var result = false;

        if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent)
            || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0,4))) {
            result = true;
        }

        return result;
    };

    Fileman.tooltips = function(options)
    {
        var me = arguments.callee;

        if (!(this instanceof me))
        {
            // Factory

            var result = false;

            if (!Fileman.isMobile()) {
                result = new me(options);
            }

            return result;

        } else {

            // Constructor

            var my = {
                init: function(options)
                {
                    var that = this;

                    this.options = $.extend(true, {
                        handlers: {
                            show: function(el) {
                                el.click(function() {
                                    that.show(el);
                                });
                            },
                            hide: function(el) {
                                el.mouseleave(function() {
                                    that.clear(el);
                                });
                            }
                        },
                        message: 'Copied!',
                        target: '.tooltippable',
                        direction: 'n',
                        delay: 0,
                        autobind: true
                    }, options);

                    this.options.handlers.show = this.options.handlers.show.bind(this);
                    this.options.handlers.hide = this.options.handlers.hide.bind(this);

                    if (this.options.autobind) this.bind();

                    return this;
                },
                clear: function(el)
                {
                    el.removeClass(this.getClass());
                    el.removeAttr('aria-label');
                },
                show: function(el)
                {
                    var that = this;

                    var show = function() {
                        el.addClass(that.getClass());
                        el.attr('aria-label', that.options.message);
                    };

                    setTimeout(show, this.options.delay);
                },
                getClass: function()
                {
                    return 'tooltipped tooltipped-' + this.options.direction;
                },
                bind: function()
                {
                    var that = this;

                    var target = this.options.target;

                    if ($.type(target) === 'string') {
                        target = $(target);
                    } else if (!$.isArray(target)) {
                        var target = [target];
                    }

                    target.each(function(idx, el)
                    {
                        if (!$.isNumeric(idx)) {
                            el = idx;
                        }

                        var el = $(el);

                        that.options.handlers.show(el);

                        that.options.handlers.hide(el);
                    });
                }
            };

            if (options) {
                my.init(options);
            }

            return my;
        }
    };

    Fileman.copyboard = function(options)
    {
        options = $.extend(true, {
            target: '.clipboardable',
            tooltips: {
                enabled: true,
                autobind: false
            }
        }, options);

        var clipboard = new ClipboardJS(options.target);

        if (options.tooltips.enabled) {
            var tooltips = Fileman.tooltips(options.tooltips);
        }

        if (tooltips) {
            clipboard.on('success', function (e) {
                tooltips.show($(e.trigger));
            });
        }

        var target = options.target;

        if ($.type(target) === 'string') {
            target = $(target);
        } else if (!$.isArray(target)) {
            var target = [target];
        }

        target.each(function (idx, el)
        {
            if (!$.isNumeric(idx)) {
                el = idx;
            }

            var el = $(el);

            if (tooltips) {
                el.mouseleave(function () {
                    tooltips.clear(el);
                });
            }

            el.click(function (e) {
                e.preventDefault();
            });
        });
    };
}(window.kQuery);
