/**
 * @package     FILEman
 * @copyright   Copyright (C) 2011 Timble CVBA. (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

kQuery(function($) {
    var options = {
            history: false,
            shareEl: true,
            shareButtons: [
                {id:'download', label: Koowa.translate('Download'), url:'{{raw_image_url}}', download:true}
            ],
            closeOnScroll: false,
            showAnimationDuration: 0,
            hideAnimationDuration: 0
        },
        pswpElement = document.querySelectorAll('.pswp')[0],
        openGallery = function(items, index) {

            options.index = index;

            var instance = new PhotoSwipe(pswpElement, PhotoSwipeUI_Default, items, options);

            // Get data just in time for faster startup
            instance.listen('gettingData', function(index, item) {
                if (!item.src && !item.html) {
                    var element = item.el;

                    item.src = element.attr('href');
                    item.w = parseInt(element.data('width'), 10);
                    item.h = parseInt(element.data('height'), 10);

                    if (element.find('.koowa_header__item')) {
                        item.title = $.trim(element.find('.js-gallery-caption').text());
                    }
                }
            });

            instance.listen('imageLoadComplete', function(index, item) {
                if (item.src) {
                    $(document).trigger('photoswipeImageView', [item]);
                }
            });

            instance.init();
        },
        getGalleryItems = function(gallery) {
            var items = [];

            $(gallery).find('.js-lightbox-item').each(function(i, element) {
                element = $(element);
                element.data('index', i);

                items.push({
                    el: element // save link to element for getThumbBoundsFn
                });
            });

            return items;
        };


        $('a.js-lightbox-item').click(function( event ) {

            event.preventDefault();

            if ($(this).length) {

                var elements = getGalleryItems($(this).parents('.koowa_media--gallery'));

                if (elements) {
                    openGallery(elements, $(this).data('index'));
                }
            }
        });

        $(document.body).on('click', '.pswp__share--download', function(e) {
            var target = $(e.target),
                href = target.attr('href');

            if (href.indexOf('force-download=1') === -1) {
                target.attr('href', href+(href.indexOf('?') === -1 ? '?' : '&')+'force-download=1');
            }
        });
});
