<?php
/**
 * Copyright (c) 2006-2022 LogicalDOC
 * WebSites: www.logicaldoc.com
 * 
 * No bytes were intentionally harmed during the development of this application.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
defined('_JEXEC') or die;
?>
<script type="text/javascript">
    var i = <?php echo $this->size; ?>;
    var j = i * 2;
    $(document).ready(function() {
        $('#saveConfiguration').button().click(function() {
            if ($("#formConfiguration").validationEngine('validate')) {
                document.formConfiguration.task.value = 'search';
                document.formConfiguration.submit();
            }
        });

        $('#cancelConfiguration').button().click(function() {
            document.formConfiguration.task.value = 'cancel';
            document.formConfiguration.submit();
        });

        $('#tab').tabs();

        $('#formConfiguration').validationEngine();

        $('#message').dialog({
            modal: true,
            autoOpen: false,
            buttons: {
                Ok: function() {
                    $(this).dialog("close");
                }
            }
        });

        var rowConfiguration;
        rowConfiguration = <?= json_encode($this->rows); ?>;
        $('#name').focusout(function(e) {
            //funciona cuando se preciona la tecla enter
            var name = $(this).val();
            for (var i = 0; i < rowConfiguration.length; i++) {
                if (name == rowConfiguration[i].name) {
                    $('#message').dialog("open");
                    $(this).val('');
                    return false;//para que no se actualize la pagina
                }
            }//fin for
        });

        $('#access').change(function() {
            var access = $('#access').val();
            if (access == 'Public') {
                $('#passwordAccess').attr('class', '');
            }
            else {
                $('#passwordAccess').attr('class', 'validate[required] text-input');
            }
        });

        $('#newProperty').button().click(function() {
            i++;
            j++;
            html = "";
            html = "<li id='" + i + "'>"
            html += "<span class='label'><?php echo JText::_('COM_LOGICALDOC_PROPERTY'); ?>:</span> <input type='text' name='field" + (j++) + "' class='validate[required] text-input' />"
            html += " <span class='label'><?php echo JText::_('COM_LOGICALDOC_THE_NAME_OF_THE_COLUMN_IN_TABLE'); ?>:</span> <input type='text' name='field" + (j++) + "' class='validate[required] text-input' />"
            html += " <a class='delete ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only delete' title='" + i + "' >";
            html += "<span class='ui-button-text'>"
            html += "<i class='fa fa-trash'></i>";
            html += "</span>"
            html += "</a>";
            html += "</li>"
            $('#property').append(html);
            return false;
        });

        $('#property').on('click', '.delete', function() {
            var id = $(this).attr('title');
            $('#' + id).remove();
        });
        
        $('#access').selectmenu();
        
        $('.delete').button();
    });
</script>
<style type="text/css">
    #message p{
        margin: 10px;
    }
</style>
<div id="message" title="Mensaje">
    <p>
        <span class="ui-icon ui-icon-circle-check" style="float:left;"></span>
        <?php echo JText::_('COM_LOGICALDOC_THIS_NAME_ALREADY_EXISTS'); ?>        
    </p>
</div>
<form action= "" method="post" name="formConfiguration"
      id="formConfiguration" enctype="multipart/form-data" >
    <div id="tab">
        <ul>
            <li><a href="#dato"><?php echo JText::_('COM_LOGICALDOC_ACCESS_CONFIGURATION') ?></a></li>
            <li><a href="#tabla"><?php echo JText::_('COM_LOGICALDOC_SETTING_THE_TABLE') ?></a></li>
            <li><a href="#metadata" style="display:none"><?php echo JText::_('COM_LOGICALDOC_METADATA') ?></a></li>
        </ul>
        <div id="dato">
            <table width="100%">
                <?php if ($this->row->name == '') { ?>
                    <tr>
                        <td ><label for="name" class="label-title"><?php echo JText::_('COM_LOGICALDOC_NAME') ?>:</label></td>
                        <td>
                            <input type="text" name="name" id="name" value="<?php echo $this->row->name; ?>" class="validate[required] text-input" size="50" placeholder="<?php echo JText::_('COM_LOGICALDOC_NAME') ?>"/>
                        </td>
                    </tr>
                <?php } else { ?>
                    <tr>
                        <td ><label for="name" class="label-title"><?php echo JText::_('COM_LOGICALDOC_NAME') ?>:</label></td>
                        <td>
                            <input type="text" name="name" id="name" value="<?php echo $this->row->name; ?>" size="50" disabled="disabled" />
                        </td>
                    </tr>                    
                <?php } ?>
                <tr>
                    <td ><label for="user" class="label-title"><?php echo JText::_('COM_LOGICALDOC_USER') ?>:</label></td>
                    <td >
                        <input type="text" name="user" id="user" size="50" value="<?php echo $this->row->user; ?>" class="validate[required] text-input" placeholder="<?php echo JText::_('COM_LOGICALDOC_USER') ?>"/>
                    </td>
                </tr>
                <?php if ($this->row->password == '') { ?>
                    <tr>
                        <td ><label for="password" class="label-title"><?php echo JText::_('COM_LOGICALDOC_PASSWORD'); ?>:</label></td>
                        <td >
                            <input type="password" name="password" id="password" size="50" value="" class="validate[required] text-input" placeholder="<?php echo JText::_('COM_LOGICALDOC_PASSWORD') ?>"/>
                        </td>
                    </tr>
                <?php } else { ?>
                    <tr>
                        <td ><label for="password" class="label-title"><?php echo JText::_('COM_LOGICALDOC_PASSWORD'); ?>:</label></td>
                        <td >
                            <input type="password" name="password" id="password" size="50" value="" />
                        </td>
                    </tr>
                <?php } ?>
                <tr>
                    <td ><label for="url" class="label-title"><?php echo JText::_('URL'); ?>:</label></td>
                    <td>
                        <input type="text" name="url" id="url" size="50" value="<?php echo $this->row->url; ?>" class="validate[required] text-input" placeholder="URL"/>
                    </td>
                </tr>
                <tr>
                    <td ><label for="ldocPath" class="label-title"><?php echo JText::_('COM_LOGICALDOC_PATH'); ?>:</label></td>
                    <td>
                        <input type="text" name="ldocPath" id="ldocPath" size="50" value="<?php echo $this->row->ldocPath; ?>" class="validate[required] text-input" placeholder="<?php echo JText::_('COM_LOGICALDOC_PATH') ?>"/>
                    </td>
                </tr>
                <tr>
                    <td ><label for="access" class="label-title"><?php echo JText::_('COM_LOGICALDOC_ACCESS_LEVEL') ?>:</label></td>
                    <td>
                        <select name="access" id="access" class="validate[required]">
                            <option value="Public" <?php if ("Public" == $this->row->access) echo "selected='selected'" ?>><?php echo JText::_('COM_LOGICALDOC_PUBLIC') ?></option>
                            <option value="Private" <?php if ("Private" == $this->row->access) echo "selected='selected'" ?>><?php echo JText::_('COM_LOGICALDOC_PRIVATE') ?></option>
                        </select>
                    </td>
                </tr>  
                <?php if ($this->row->passwordAccess == '') { ?>
                    <tr>
                        <td ><label for="passwordAccess" class="label-title"><?php echo JText::_('COM_LOGICALDOC_ACCESS_PASSWORD') ?>:</label></td>
                        <td>
                            <input type="password" name="passwordAccess" id="passwordAccess" size="50" value="" class="" placeholder="<?php echo JText::_('COM_LOGICALDOC_ACCESS_PASSWORD') ?>"/> 
                        </td>
                    </tr>
                <?php } else { ?>
                    <tr>
                        <td ><label for="passwordAccess" class="label-title"><?php echo JText::_('COM_LOGICALDOC_ACCESS_PASSWORD') ?>:</label></td>
                        <td>
                            <input type="password" name="passwordAccess" id="passwordAccess" size="50" value=""/> 
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div><!--Fin tab Configuration-->
        <div id="tabla">
            <table width="100%">
                <tr>
                    <td><label class="label-title"><?php echo JText::_('COM_LOGICALDOC_SHOW_FIELD') ?>:</label></td>
                    <td>
                        <div style="display: inline-block;">
                            <input type="checkbox" name="icon" id="icon" value="1" <?php if ($this->row->icon == 1) echo "checked='checked'"; ?>/>
                            <label for="icon"><?php echo JText::_('COM_LOGICALDOC_ICON') ?></label>
                        </div>
                        <div style="display: inline-block;">
                            <input type="checkbox" name="size" id="size" value="1" <?php if ($this->row->size == 1) echo "checked='checked'"; ?>/>
                            <label for="size"><?php echo JText::_('COM_LOGICALDOC_SIZE') ?></label>
                        </div>
                        <div style="display: inline-block;">
                            <input type="checkbox" name="updateDate" id="updateDate" value="1" <?php if ($this->row->updateDate == 1) echo "checked='checked'"; ?>/>
                            <label for=""updateDate><?php echo JText::_('COM_LOGICALDOC_UPDATE_DATE') ?></label>
                        </div>
                        <div style="display: inline-block;">
                            <input type="checkbox" name="author" id="author" value="1" <?php if ($this->row->author == 1) echo "checked='checked'"; ?>/>
                            <label for="author"><?php echo JText::_('COM_LOGICALDOC_AUTHOR') ?></label>
                        </div>
                        <div style="display: inline-block;">
                            <input type="checkbox" name="version" id="version" value="1" <?php if ($this->row->version == 1) echo "checked='checked'"; ?>/>
                            <label for="version"><?php echo JText::_('COM_LOGICALDOC_VERSION') ?></label>
                        </div>                        
                    </td>
                </tr>
                <tr>
                    <td><label for="showEntries" class="label-title"><?php echo JText::_('COM_LOGICALDOC_SHOW_IN_TABLE') ?>:</label></td>      
                    <td>
                        <select name="showEntries" size="1" id="showEntries">
                            <option value="10" <?php if ($this->row->showEntries == 10) echo "selected='selected'" ?> >10</option>
                            <option value="25" <?php if ($this->row->showEntries == 25) echo "selected='selected'" ?>>25</option>
                            <option value="50" <?php if ($this->row->showEntries == 50) echo "selected='selected'" ?>>50</option>
                            <option value="100" <?php if ($this->row->showEntries == 100) echo "selected='selected'" ?>>100</option>
                        </select>
                        <?php echo JText::_('COM_LOGICALDOC_REGISTRIES') ?>
                    </td>
                </tr>  
            </table>
        </div>
        <div id="metadata" style="display:none">
            <table id="tablaMetadata" >
                <thead>
                    <tr>
                        <th align="left"> <?php echo JText::_('COM_LOGICALDOC_NEW_PROPERTY'); ?></th>
                        <th align="right">
                            <button id="newProperty" title="<?php echo JText::_('COM_LOGICALDOC_NEW_PROPERTY'); ?>" >
                                <i class="fa fa-plus"></i>                                
                            </button>
                        </th>
                    </tr>
                </thead>
                <tbody >
                    <tr>
                        <td colspan="2" align="left">
                            <ul id="property">
                                <?php
                                $i = 0;
                                $j = 0;
                                foreach ($this->rowsMetadata as $rowMetadata) {
                                    ?>
                                    <li id="<?php echo $i ?>">
                                        <span class="label"><?php echo JText::_('COM_LOGICALDOC_PROPERTY'); ?>:</span> 
                                        <input type="text" class="validate[required] text-input" name="field<?php echo $j++; ?>" value="<?php echo $rowMetadata->property; ?>">
                                        <span class="label"><?php echo JText::_('COM_LOGICALDOC_THE_NAME_OF_THE_COLUMN_IN_TABLE'); ?>:</span> 
                                        <input type="text" class="validate[required] text-input" name="field<?php echo $j++; ?>" value="<?php echo $rowMetadata->title; ?>">
                                        <a title="<?php echo $i ?>" class="delete">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </li>
                                    <?php
                                    $i++;
                                }
                                ?>
                            </ul>
                        </td>
                    </tr>
                </tbody>
                <tfoot>
            </table>
        </div>        
        <div class="panel-button">
            <button id="saveConfiguration">
                <i class="fa fa-save"></i>
                <?php echo JText::_('COM_LOGICALDOC_SAVE') ?>
            </button>
            <button id="cancelConfiguration">
                <i class="fa fa-remove"></i>
                <?php echo JText::_('COM_LOGICALDOC_CANCEL') ?>
            </button>   
        </div> 
        <input type="hidden" name="idConfiguration" value="<?php echo $this->row->idConfiguration; ?>" />
        <input type="hidden" name="option" value="com_logicaldoc" />
        <input type="hidden" name="view" value="configuration"/>
        <input type="hidden" name="task" value="" />     
    </div><!--fin del tabs-->
</form>