<?php
/**
 * Copyright (c) 2006-2022 LogicalDOC
 * WebSites: www.logicaldoc.com
 * 
 * No bytes were intentionally harmed during the development of this application.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
defined('_JEXEC') or die;

use Swagger\Client\Model\WSFolder;
use Swagger\Client\Model\WSDocument;
use logicaldoc\LDOCWebservice10;

require_once (JPATH_COMPONENT . DS . 'IconSelector.php');
?>

<style type="text/css">
    #basic {
        padding: 10px;
    }
</style>
<script type="text/javascript">

    $(document).ready(function() {
        var iDisplayLength = <?php echo $this->rowConfiguration->showEntries; ?>;
        var icon = <?php echo $this->rowConfiguration->icon; ?>;
        var size = <?php echo $this->rowConfiguration->size; ?>;
        var updateDate = <?php echo $this->rowConfiguration->updateDate; ?>;
        var author = <?php echo $this->rowConfiguration->author; ?>;
        var version = <?php echo $this->rowConfiguration->version; ?>;
        var iconValor = false;
        var sizeValor = false;
        var updateDateValor = false;
        var authorValor = false;
        var versionValor = false;
        if (icon == 1) {
            iconValor = true;
        }
        if (size === 1) {
            sizeValor = true;
        }
        if (updateDate == 1) {
            updateDateValor = true;
        }
        if (author == 1) {
            authorValor = true;
        }
        if (version == 1) {
            versionValor = true;
        }
        var asInitVals = new Array();
        var oTable = $('#tablaDesktop').dataTable({
            "bJQueryUI": true,
            "sPaginationType": "full_numbers",
            "iDisplayLength": iDisplayLength,
            "bFilter": true,
            "scrollX": true,
            "aoColumns": [
                {"bSortable": false, "bSearchable": false, "bVisible": iconValor},
                {"bSortable": true, "bVisible": true},
				{"bSortable": true, "bVisible": sizeValor,
					"mRender": function(size, type, full) {
								if (type == 'display') {
									if (size === '0') {return '0 B';}
									if (size == 0) {return ' ';}
									var sizek = Math.floor( size / 1024 ).toFixed(0) * 1;
									return sizek.toLocaleString() + ' kB';
								}
							return size;
						}
				}, 
                {"bSortable": true, "bVisible": updateDateValor,
					"mRender": function(date, type, full) {
									if (type == 'display') {
										var mydt = new Date(date);
							    		return mydt.toLocaleDateString() + " " + mydt.toLocaleTimeString();
							  		}
                                  return date;
                               }
      			},
                {"bSortable": true, "bVisible": authorValor},
                {"bSortable": false, "bVisible": versionValor}
                <?php for ($i = 0; $i < count($this->rowsMetadata);$i++ ) { ?>
                ,{"bSortable": true, "bVisible": true}
                <?php } ?>
            ],
            "aaSorting": [[0, "asc"]],
            "oLanguage": {
                "sProcessing": "<?php echo JText::_('COM_LOGICALDOC_PLEASE_WAIT') ?>",
                "sLengthMenu": "<?php echo JText::_('COM_LOGICALDOC_SHOW') ?>_MENU_ <?php echo JText::_('COM_LOGICALDOC_ENTRIES') ?>",
                                "sZeroRecords": "<?php echo JText::_('COM_LOGICALDOC_NOTHING_FOUND_SORRY') ?>",
                                "sInfo": "<?php echo JText::_('COM_LOGICALDOC_SHOWING') ?>_START_ <?php echo JText::_('COM_LOGICALDOC_TO') ?> _END_ <?php echo JText::_('COM_LOGICALDOC_OF') ?> _TOTAL_ <?php echo JText::_('COM_LOGICALDOC_ENTRIES') ?>",
                                                "sInfoEmpty": "<?php echo JText::_('COM_LOGICALDOC_SHOWING') ?> 0 <?php echo JText::_('COM_LOGICALDOC_TO') ?> 0 <?php echo JText::_('COM_LOGICALDOC_OF') ?> 0 <?php echo JText::_('COM_LOGICALDOC_ENTRIES') ?>",
                                                                "sInfoFiltered": "(<?php echo JText::_('COM_LOGICALDOC_FILTERED_FROM') ?> _MAX_ <?php echo JText::_('COM_LOGICALDOC_TOTAL_ENTRIES') ?>)",
                                                                "sInfoPostFix": "",
                                                                "sSearch": "<?php echo JText::_('COM_LOGICALDOC_SEARCH'); ?>",
                                                                "sUrl": "",
                                                                "oPaginate": {
                                                                    "sFirst": "<?php echo JText::_('COM_LOGICALDOC_FIRST') ?>",
                                                                    "sPrevious": "<?php echo JText::_('COM_LOGICALDOC_PREVIOUS') ?>",
                                                                    "sNext": "<?php echo JText::_('COM_LOGICALDOC_NEXT') ?>",
                                                                    "sLast": "<?php echo JText::_('COM_LOGICALDOC_LAST') ?>"
                                                                }
                                                            }
                                                        });

                                                        $('#searchBasic').button().click(function() {
                                                            if ($('#formSearch').validationEngine('validate')) {
                                                                document.formSearch.task.value = 'searchBasic';
                                                                document.formSearch.submit();
                                                            }
                                                            return false;
                                                        });
                                                        
                                                        $('#bSearchAdvanced').button().click(function() {
                                                            $('#basic').css('display', 'none');
                                                            $('#advanced').css('display', 'block');
                                                            $('#tablaDesktop_wrapper').css('display', 'none');
                                                            $("#bSearchAdvanced").css('display', 'none');
                                                            return false;
                                                        });

                                                        $('#formSearch').validationEngine();
                                                    });
</script>
<?php

    function optionLabel($options) {
        foreach ($options as $option) {
            if ($option->isSelected() == 'true') {
                return $option->getLabel();
            }
        }
    }
   
    function optionValue($options) {
        foreach ($options as $option) {
            if ($option->isSelected() == 'true') {
                return $option->getValue();
            }
        }
    }

    
function printFolder(WSFolder $folder, LDOCWebservice10 $ws, $rowsMetadata) { ?>
    <tr>       
		<td align="center">
		   <img src="components/com_logicaldoc/assets/images/menuitem_childs.png" />   
        </td>
        <td style="white-space: nowrap;">
            <a  href="index.php?option=com_logicaldoc&view=desktop&task=folder&uuid=<?php echo $folder->getId(); ?>" >
                <?php echo $folder->getName(); ?>
            </a>
        </td>
        <td style="white-space: nowrap;">
            
        </td>
        <td style="white-space: nowrap;">            
            <?php
			$ymd = DateTime::createFromFormat('Y-m-d H:i:s O', $folder->getCreation());
			echo $ymd->format('c');			
            ?>
        </td>        
        <td style="white-space: nowrap;">
    <?php echo $folder->getCreator(); ?>
        </td>        
        <td>
        </td> 
        <?php
        if (!empty($rowsMetadata)) {
            
            $property = explode(".", $rowsMetadata[0]->property);
            $group = str_replace("okp", "okg", $property[0]);
            $formElements = $ws->getPropertyGroupProperties($folder->id, $group);

            foreach ($rowsMetadata as $rowMetadata) {
                ?>
                <td style="white-space: nowrap;">
                    <?php
                    foreach ($formElements as $formElement) {
                        if ($formElement instanceof Input) {
                            $name = $formElement->getName();
                            $value = $formElement->getValue();
                            if ($rowMetadata->property == $name) {
                                echo $value;
                            }
                        } else if ($formElement instanceof Select) {
                            $name = $formElement->getName();
                            if ($rowMetadata->property == $name) {
                                echo optionLabel($formElement->getOptions());
                            }
                        } else if ($formElement instanceof TextArea) {
                            $name = $formElement->getName();
                            $value = $formElement->getValue();
                            if ($rowMetadata->property == $name) {
                                echo $value;
                            }
                        } else if ($formElement instanceof CheckBox) {
                            $name = $formElement->getName();
                            $value = $formElement->isValue();
                            if ($rowMetadata->property == $name) {
                                echo $value;
                            }
                        }
                    }
                    ?>
                </td>
            <?php }
        }
        ?>
    </tr>
    <?php
}

function printDocument(WSDocument $document, $rowConfiguration,LDOCWebservice10 $ws, $rowsMetadata) {
    ?>
    <tr>
        <td align="center">
            <img src="components/com_logicaldoc/assets/mimes/<?php echo IconSelector::selectIcon($document->getType()); ?>" />            
        </td>
        <td style="white-space: nowrap;">            
            <a  href="index.php?option=com_logicaldoc&view=desktop&task=download&format=raw&uuid=<?php echo $document->getId(); ?>&id=<?php echo $rowConfiguration->idConfiguration; ?>" >                
                <?php echo $document->getFileName(); ?>
            </a>               
        </td >
        <td style="white-space: nowrap;">
            <?php echo $document->getFileSize(); ?>
        </td>
        <td style="white-space: nowrap;">
            <?php
			$ymd = DateTime::createFromFormat('Y-m-d H:i:s O', $document->getDate());
			echo $ymd->format('c');			
            ?>
        </td>
        <td style="white-space: nowrap;">
            <?php echo $document->getCreator(); ?>
        </td>
        <td style="white-space: nowrap;">
            <?php echo $document->getVersion(); ?>
        </td>  
        <?php
        if (!empty($rowsMetadata)) {
            
            $property = explode(".", $rowsMetadata[0]->property);
            $group = str_replace("okp", "okg", $property[0]);
            $formElements = $ws->getPropertyGroupProperties($document->getId(), $group);

            foreach ($rowsMetadata as $rowMetadata) {
                ?>
                <td style="white-space: nowrap;">
                    <?php
                    foreach ($formElements as $formElement) {
                        if ($formElement instanceof Input) {
                            $name = $formElement->getName();
                            $value = $formElement->getValue();
                            if ($rowMetadata->property == $name) {
                                echo $value;
                            }
                        } else if ($formElement instanceof Select) {
                            $name = $formElement->getName();
                            if ($rowMetadata->property == $name) {
                                echo optionLabel($formElement->getOptions());
                            }
                        } else if ($formElement instanceof TextArea) {
                            $name = $formElement->getName();
                            $value = $formElement->getValue();
                            if ($rowMetadata->property == $name) {
                                echo $value;
                            }
                        } else if ($formElement instanceof CheckBox) {
                            $name = $formElement->getName();
                            $value = $formElement->isValue();
                            if ($rowMetadata->property == $name) {
                                echo $value;
                            }
                        }
                    }
                    ?>
                </td>
            <?php }
        }
        ?>
    </tr>
    <?php
}

function redondear($numero, $decimales) {
    $factor = pow(10, $decimales);
    return (round($numero * $factor) / $factor);
}

function formatSize($size) {
    $srt = "BIG";
    if ($size / 1024 < 1) {
        $srt = $size . " byte";
    } else if ($size / 1048576 < 1) {
        $srt = redondear(($size / 1024), 1) . " kB";
    } else if ($size / 1073741824 < 1) {
        $srt = redondear(($size / 1048576), 1) . " MB";
    } else if ($size / 1099511627776 < 1) {
        $srt = redondear(($size / 1073741824), 1) . " GB";
    }
    return $srt;
}

if ($this->enter == 0) {
    ?>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#send').click(function() {
                document.formAccess.task.value = 'send';
                document.formAccess.submit();
            });

            $("#send").button();
        });
    </script>
    <div class=""> 
        <?php if ($this->message != '') { ?>
            <p style="color: #ff0000;"><?php echo $this->message; ?></p>
            <?php } ?>
        <h3 class="contentpassword-title"><?php echo JText::_('COM_LOGICALDOC_RESTRICTED_CONTENT') ?></h3>
        <p class="contentpassword-description"><?php echo JText::_('COM_LOGICALDOC_PROTECTED_AREA') ?><br>
    <?php echo JText::_('COM_LOGICALDOC_PRIVATE_DESCRIPTION') ?></p>
        <form action= "" method="post" id="formAccess" name="formAccess" class="contentpassword-form">
            <table>
                <tr>
                    <td align="right"><?php echo JText::_('COM_LOGICALDOC_PASSWORD') ?></td>
                    <td><input type="password" name="passwordAccess" id="passwordAccess" value=""/></td>
                    <td><button id="send"><?php echo JText::_('COM_LOGICALDOC_SEND'); ?></button></td>
                </tr>
            </table>        
            <input type="hidden" name="option" value="com_logicaldoc" />
            <input type="hidden" name="view" value="desktop"/>            
            <input type="hidden" name="task" value="" /> 
            <input type="hidden" name="id" value="<?php echo $this->rowConfiguration->idConfiguration; ?>"/>
        </form>
    </div>
    <?php
} else {
    if ($this->error == 0) {
        ?>   
        <h3><?php
            echo JText::_('COM_LOGICALDOC_PATH') . ':';
            $breadcrumbs = $this->session->get('breadcrumbs');
            foreach ($breadcrumbs as $uuid => $path) {
                ?>
                <a  href="index.php?option=com_logicaldoc&view=desktop&task=folder&addPath=1&uuid=<?= $uuid; ?>" >                    
                    <?php
                    if ($path == '/ldoc:root') {
                        echo JText::_('COM_LOGICALDOC_HOME');
                    } else {
                        //echo substr($path, strrpos($path, '/'));
						echo '/' .$path;
                    }
                    ?>                               
                </a>            
        <?php } ?>
        </h3>
        <div id="basic" style="margin-right: 15px; padding: 0;" width="100%">
            <form method="post" action="" name="formSearch" id="formSearch">
                <h4><?php echo JText::_('COM_LOGICALDOC_SEARCH_BY_CONTENT') ?>:</h4>    
                <input type="text" name="content" id="content" value="" style="width: 100%" class="validate[required] text-input"/> 
                <button id="searchBasic"><i class="fa fa-search"></i> <?php echo JText::_('COM_LOGICALDOC_SEARCH') ?></button>
                <input type="hidden" name="option" value="com_logicaldoc" />
                <input type="hidden" name="view" value="desktop"/>
                <input type="hidden" name="id" value="<?php echo $this->rowConfiguration->idConfiguration; ?>"/>
                <input type="hidden" name="task" value="" />
                <input type="hidden" name="document" id="document" value="1" checked="checked"/>                       
                <button id="bSearchAdvanced" /><?php echo JText::_('COM_LOGICALDOC_ADVANCED_SEARCH'); ?></button>
            </form>            
        </div>
        <div id="advanced" style="display: none;">
        <?php include ('form.php'); ?>
        </div>    
        <table id="tablaDesktop" width="100%" class="display" cellpadding="0" cellspacing="0" border="0">
            <thead>
                <tr>
                    <th > </th>
                    <th > <?php echo JText::_('COM_LOGICALDOC_NAME') ?></th>
                    <th > <?php echo JText::_('COM_LOGICALDOC_SIZE') ?></th>
                    <th style="white-space: nowrap;"> <?php echo JText::_('COM_LOGICALDOC_UPDATE_DATE') ?></th>
                    <th > <?php echo JText::_('COM_LOGICALDOC_AUTHOR') ?></th>
                    <th > <?php echo JText::_('COM_LOGICALDOC_VERSION') ?></th>
                    <?php foreach ($this->rowsMetadata as $rowMetadata) { ?>
                        <th style="white-space: nowrap;"><?php echo $rowMetadata->title; ?></th>
                    <?php } ?>
                </tr>
            </thead>
            <tbody id="tbodyDesktop">
                <?php
                foreach ($this->folders as $folder) {
                    printFolder($folder, $this->ws, $this->rowsMetadata);
                }

                foreach ($this->documents as $document) {
                    printDocument($document, $this->rowConfiguration, $this->ws, $this->rowsMetadata);
                }
                ?>
            </tbody>
            <tfoot>
        </table>
    <?php } else { ?>   
        <h2><?php echo JText::_('COM_LOGICALDOC_ERROR_THE_CONFIGURATION_IS_NOT_CORRECT_PLEASE_CHECK_YOUR_LOGICALDOC_CONFIGURATION_TO_CONNECTO_TO') ?>.</h2>
        <p>
            <?= (!empty($this->ldocMessage)) ? $this->ldocMessage : ''; ?>
        </p>
    <?php } ?>
<?php } ?>
