<?php
/**
 * @package     FILEman
 * @copyright   Copyright (C) 2020 Timble CVBA (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

class ComFilemanControllerDownload extends ComFilemanControllerAbstract
{
    protected function _initialize(KObjectConfig $config)
    {
        $config->append(array(
            'behaviors' => array('compressible'),
            'model'     => 'com:files.model.files',
            'view'      => 'download'
        ));

        parent::_initialize($config);
    }

    public function execute($action, KControllerContextInterface $context)
    {
        try
        {
            return parent::execute($action, $context);
        }
        catch(KHttpExceptionForbidden $exception)
        {
            $request = $this->getRequest();

            if ($request->isSafe() && $request->getFormat() == 'html' && $context->getName() == 'before.render')
            {
                // Re-direct the user to the previous location (using the controller referrer).
                $url     = $this->getReferrer($context);
                $message = $this->getObject('translator')->translate('You are not authorized to download the selected file');

                $this->getResponse()->setRedirect(JRoute::_($url, false), $message, 'error')
                    ->send();
            }
            else throw $exception;
        }
    }
}
