<?php
/**
 * @license    License compatible with GNU General Public License (GNU GPL); see file LICENSE
 */

/**
 * WSSystemInfo
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * LogicalDOC REST API
 *
 * This is the interactive documentation of the REST APIs exposed by LogicalDOC. You can find more information about LogicalDOC at <a href=\"https://www.logicaldoc.com\">https://www.logicaldoc.com</a> or on Twitter @logicaldoc.<br/>                Note: The access path to the API is protected with basic authentication, to be able to run the samples you must log in using the credentials of a Logicaldoc user, or passing to the request the session ID (SID) as a cookie (cookie name: `ldoc-sid`).<br/><br/>             Here is an example to list the children folders: <br/> <pre>curl -u admin:admin -H 'Accept: application/json' http://localhost:8080/services/rest/folder/listChildren?folderId=4</pre><br/><br/>RESTful Guide with curl:  <a href='https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl'>https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl</a> <br/><br/>Practical examples of use are available for various programming languages at: <a href='http://wiki.logicaldoc.com/wiki/Bindings_And_Samples'>http://wiki.logicaldoc.com/wiki/Bindings_And_Samples</a>
 *
 * OpenAPI spec version: 8.6.0-oas3
 * Contact: devel@logicaldoc.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.33
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

defined('_JEXEC') or die('Restricted access');


use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * WSSystemInfo Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class WSSystemInfo implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'WSSystemInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'product_name' => 'string',
'product' => 'string',
'release' => 'string',
'year' => 'string',
'help' => 'string',
'bugs' => 'string',
'url' => 'string',
'forum' => 'string',
'vendor' => 'string',
'vendor_address' => 'string',
'vendor_cap' => 'string',
'vendor_country' => 'string',
'vendor_city' => 'string',
'support' => 'string',
'installation_id' => 'string',
'licensee' => 'string',
'run_level' => 'string',
'features' => 'string[]',
'date' => 'string',
'host_name' => 'string'    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'product_name' => null,
'product' => null,
'release' => null,
'year' => null,
'help' => null,
'bugs' => null,
'url' => null,
'forum' => null,
'vendor' => null,
'vendor_address' => null,
'vendor_cap' => null,
'vendor_country' => null,
'vendor_city' => null,
'support' => null,
'installation_id' => null,
'licensee' => null,
'run_level' => null,
'features' => null,
'date' => null,
'host_name' => null    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'product_name' => 'productName',
'product' => 'product',
'release' => 'release',
'year' => 'year',
'help' => 'help',
'bugs' => 'bugs',
'url' => 'url',
'forum' => 'forum',
'vendor' => 'vendor',
'vendor_address' => 'vendorAddress',
'vendor_cap' => 'vendorCap',
'vendor_country' => 'vendorCountry',
'vendor_city' => 'vendorCity',
'support' => 'support',
'installation_id' => 'installationId',
'licensee' => 'licensee',
'run_level' => 'runLevel',
'features' => 'features',
'date' => 'date',
'host_name' => 'hostName'    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'product_name' => 'setProductName',
'product' => 'setProduct',
'release' => 'setRelease',
'year' => 'setYear',
'help' => 'setHelp',
'bugs' => 'setBugs',
'url' => 'setUrl',
'forum' => 'setForum',
'vendor' => 'setVendor',
'vendor_address' => 'setVendorAddress',
'vendor_cap' => 'setVendorCap',
'vendor_country' => 'setVendorCountry',
'vendor_city' => 'setVendorCity',
'support' => 'setSupport',
'installation_id' => 'setInstallationId',
'licensee' => 'setLicensee',
'run_level' => 'setRunLevel',
'features' => 'setFeatures',
'date' => 'setDate',
'host_name' => 'setHostName'    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'product_name' => 'getProductName',
'product' => 'getProduct',
'release' => 'getRelease',
'year' => 'getYear',
'help' => 'getHelp',
'bugs' => 'getBugs',
'url' => 'getUrl',
'forum' => 'getForum',
'vendor' => 'getVendor',
'vendor_address' => 'getVendorAddress',
'vendor_cap' => 'getVendorCap',
'vendor_country' => 'getVendorCountry',
'vendor_city' => 'getVendorCity',
'support' => 'getSupport',
'installation_id' => 'getInstallationId',
'licensee' => 'getLicensee',
'run_level' => 'getRunLevel',
'features' => 'getFeatures',
'date' => 'getDate',
'host_name' => 'getHostName'    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['product_name'] = isset($data['product_name']) ? $data['product_name'] : null;
        $this->container['product'] = isset($data['product']) ? $data['product'] : null;
        $this->container['release'] = isset($data['release']) ? $data['release'] : null;
        $this->container['year'] = isset($data['year']) ? $data['year'] : null;
        $this->container['help'] = isset($data['help']) ? $data['help'] : null;
        $this->container['bugs'] = isset($data['bugs']) ? $data['bugs'] : null;
        $this->container['url'] = isset($data['url']) ? $data['url'] : null;
        $this->container['forum'] = isset($data['forum']) ? $data['forum'] : null;
        $this->container['vendor'] = isset($data['vendor']) ? $data['vendor'] : null;
        $this->container['vendor_address'] = isset($data['vendor_address']) ? $data['vendor_address'] : null;
        $this->container['vendor_cap'] = isset($data['vendor_cap']) ? $data['vendor_cap'] : null;
        $this->container['vendor_country'] = isset($data['vendor_country']) ? $data['vendor_country'] : null;
        $this->container['vendor_city'] = isset($data['vendor_city']) ? $data['vendor_city'] : null;
        $this->container['support'] = isset($data['support']) ? $data['support'] : null;
        $this->container['installation_id'] = isset($data['installation_id']) ? $data['installation_id'] : null;
        $this->container['licensee'] = isset($data['licensee']) ? $data['licensee'] : null;
        $this->container['run_level'] = isset($data['run_level']) ? $data['run_level'] : null;
        $this->container['features'] = isset($data['features']) ? $data['features'] : null;
        $this->container['date'] = isset($data['date']) ? $data['date'] : null;
        $this->container['host_name'] = isset($data['host_name']) ? $data['host_name'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets product_name
     *
     * @return string
     */
    public function getProductName()
    {
        return $this->container['product_name'];
    }

    /**
     * Sets product_name
     *
     * @param string $product_name product_name
     *
     * @return $this
     */
    public function setProductName($product_name)
    {
        $this->container['product_name'] = $product_name;

        return $this;
    }

    /**
     * Gets product
     *
     * @return string
     */
    public function getProduct()
    {
        return $this->container['product'];
    }

    /**
     * Sets product
     *
     * @param string $product product
     *
     * @return $this
     */
    public function setProduct($product)
    {
        $this->container['product'] = $product;

        return $this;
    }

    /**
     * Gets release
     *
     * @return string
     */
    public function getRelease()
    {
        return $this->container['release'];
    }

    /**
     * Sets release
     *
     * @param string $release release
     *
     * @return $this
     */
    public function setRelease($release)
    {
        $this->container['release'] = $release;

        return $this;
    }

    /**
     * Gets year
     *
     * @return string
     */
    public function getYear()
    {
        return $this->container['year'];
    }

    /**
     * Sets year
     *
     * @param string $year year
     *
     * @return $this
     */
    public function setYear($year)
    {
        $this->container['year'] = $year;

        return $this;
    }

    /**
     * Gets help
     *
     * @return string
     */
    public function getHelp()
    {
        return $this->container['help'];
    }

    /**
     * Sets help
     *
     * @param string $help help
     *
     * @return $this
     */
    public function setHelp($help)
    {
        $this->container['help'] = $help;

        return $this;
    }

    /**
     * Gets bugs
     *
     * @return string
     */
    public function getBugs()
    {
        return $this->container['bugs'];
    }

    /**
     * Sets bugs
     *
     * @param string $bugs bugs
     *
     * @return $this
     */
    public function setBugs($bugs)
    {
        $this->container['bugs'] = $bugs;

        return $this;
    }

    /**
     * Gets url
     *
     * @return string
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     *
     * @param string $url url
     *
     * @return $this
     */
    public function setUrl($url)
    {
        $this->container['url'] = $url;

        return $this;
    }

    /**
     * Gets forum
     *
     * @return string
     */
    public function getForum()
    {
        return $this->container['forum'];
    }

    /**
     * Sets forum
     *
     * @param string $forum forum
     *
     * @return $this
     */
    public function setForum($forum)
    {
        $this->container['forum'] = $forum;

        return $this;
    }

    /**
     * Gets vendor
     *
     * @return string
     */
    public function getVendor()
    {
        return $this->container['vendor'];
    }

    /**
     * Sets vendor
     *
     * @param string $vendor vendor
     *
     * @return $this
     */
    public function setVendor($vendor)
    {
        $this->container['vendor'] = $vendor;

        return $this;
    }

    /**
     * Gets vendor_address
     *
     * @return string
     */
    public function getVendorAddress()
    {
        return $this->container['vendor_address'];
    }

    /**
     * Sets vendor_address
     *
     * @param string $vendor_address vendor_address
     *
     * @return $this
     */
    public function setVendorAddress($vendor_address)
    {
        $this->container['vendor_address'] = $vendor_address;

        return $this;
    }

    /**
     * Gets vendor_cap
     *
     * @return string
     */
    public function getVendorCap()
    {
        return $this->container['vendor_cap'];
    }

    /**
     * Sets vendor_cap
     *
     * @param string $vendor_cap vendor_cap
     *
     * @return $this
     */
    public function setVendorCap($vendor_cap)
    {
        $this->container['vendor_cap'] = $vendor_cap;

        return $this;
    }

    /**
     * Gets vendor_country
     *
     * @return string
     */
    public function getVendorCountry()
    {
        return $this->container['vendor_country'];
    }

    /**
     * Sets vendor_country
     *
     * @param string $vendor_country vendor_country
     *
     * @return $this
     */
    public function setVendorCountry($vendor_country)
    {
        $this->container['vendor_country'] = $vendor_country;

        return $this;
    }

    /**
     * Gets vendor_city
     *
     * @return string
     */
    public function getVendorCity()
    {
        return $this->container['vendor_city'];
    }

    /**
     * Sets vendor_city
     *
     * @param string $vendor_city vendor_city
     *
     * @return $this
     */
    public function setVendorCity($vendor_city)
    {
        $this->container['vendor_city'] = $vendor_city;

        return $this;
    }

    /**
     * Gets support
     *
     * @return string
     */
    public function getSupport()
    {
        return $this->container['support'];
    }

    /**
     * Sets support
     *
     * @param string $support support
     *
     * @return $this
     */
    public function setSupport($support)
    {
        $this->container['support'] = $support;

        return $this;
    }

    /**
     * Gets installation_id
     *
     * @return string
     */
    public function getInstallationId()
    {
        return $this->container['installation_id'];
    }

    /**
     * Sets installation_id
     *
     * @param string $installation_id installation_id
     *
     * @return $this
     */
    public function setInstallationId($installation_id)
    {
        $this->container['installation_id'] = $installation_id;

        return $this;
    }

    /**
     * Gets licensee
     *
     * @return string
     */
    public function getLicensee()
    {
        return $this->container['licensee'];
    }

    /**
     * Sets licensee
     *
     * @param string $licensee licensee
     *
     * @return $this
     */
    public function setLicensee($licensee)
    {
        $this->container['licensee'] = $licensee;

        return $this;
    }

    /**
     * Gets run_level
     *
     * @return string
     */
    public function getRunLevel()
    {
        return $this->container['run_level'];
    }

    /**
     * Sets run_level
     *
     * @param string $run_level run_level
     *
     * @return $this
     */
    public function setRunLevel($run_level)
    {
        $this->container['run_level'] = $run_level;

        return $this;
    }

    /**
     * Gets features
     *
     * @return string[]
     */
    public function getFeatures()
    {
        return $this->container['features'];
    }

    /**
     * Sets features
     *
     * @param string[] $features features
     *
     * @return $this
     */
    public function setFeatures($features)
    {
        $this->container['features'] = $features;

        return $this;
    }

    /**
     * Gets date
     *
     * @return string
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param string $date date
     *
     * @return $this
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets host_name
     *
     * @return string
     */
    public function getHostName()
    {
        return $this->container['host_name'];
    }

    /**
     * Sets host_name
     *
     * @param string $host_name host_name
     *
     * @return $this
     */
    public function setHostName($host_name)
    {
        $this->container['host_name'] = $host_name;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
