<?php
/**
 * @license    License compatible with GNU General Public License (GNU GPL); see file LICENSE
 */

/**
 * WSSearchOptions
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * LogicalDOC REST API
 *
 * This is the interactive documentation of the REST APIs exposed by LogicalDOC. You can find more information about LogicalDOC at <a href=\"https://www.logicaldoc.com\">https://www.logicaldoc.com</a> or on Twitter @logicaldoc.<br/>                Note: The access path to the API is protected with basic authentication, to be able to run the samples you must log in using the credentials of a Logicaldoc user, or passing to the request the session ID (SID) as a cookie (cookie name: `ldoc-sid`).<br/><br/>             Here is an example to list the children folders: <br/> <pre>curl -u admin:admin -H 'Accept: application/json' http://localhost:8080/services/rest/folder/listChildren?folderId=4</pre><br/><br/>RESTful Guide with curl:  <a href='https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl'>https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl</a> <br/><br/>Practical examples of use are available for various programming languages at: <a href='http://wiki.logicaldoc.com/wiki/Bindings_And_Samples'>http://wiki.logicaldoc.com/wiki/Bindings_And_Samples</a>
 *
 * OpenAPI spec version: 8.6.0-oas3
 * Contact: devel@logicaldoc.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.33
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

defined('_JEXEC') or die('Restricted access');


use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * WSSearchOptions Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class WSSearchOptions implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'WSSearchOptions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'max_hits' => 'int',
'type' => 'int',
'expression' => 'string',
'name' => 'string',
'description' => 'string',
'top_operator' => 'string',
'case_sensitive' => 'int',
'retrieve_aliases' => 'int',
'filter_ids' => 'int[]',
'folder_id' => 'int',
'search_in_sub_path' => 'int',
'expression_language' => 'string',
'size_min' => 'int',
'size_max' => 'int',
'format' => 'string',
'fields' => 'string[]',
'language' => 'string',
'date_from' => 'string',
'date_to' => 'string',
'creation_from' => 'string',
'creation_to' => 'string',
'template' => 'int'    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'max_hits' => 'int32',
'type' => 'int32',
'expression' => null,
'name' => null,
'description' => null,
'top_operator' => null,
'case_sensitive' => 'int32',
'retrieve_aliases' => 'int32',
'filter_ids' => 'int64',
'folder_id' => 'int64',
'search_in_sub_path' => 'int32',
'expression_language' => null,
'size_min' => 'int64',
'size_max' => 'int64',
'format' => null,
'fields' => null,
'language' => null,
'date_from' => null,
'date_to' => null,
'creation_from' => null,
'creation_to' => null,
'template' => 'int64'    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'max_hits' => 'maxHits',
'type' => 'type',
'expression' => 'expression',
'name' => 'name',
'description' => 'description',
'top_operator' => 'topOperator',
'case_sensitive' => 'caseSensitive',
'retrieve_aliases' => 'retrieveAliases',
'filter_ids' => 'filterIds',
'folder_id' => 'folderId',
'search_in_sub_path' => 'searchInSubPath',
'expression_language' => 'expressionLanguage',
'size_min' => 'sizeMin',
'size_max' => 'sizeMax',
'format' => 'format',
'fields' => 'fields',
'language' => 'language',
'date_from' => 'dateFrom',
'date_to' => 'dateTo',
'creation_from' => 'creationFrom',
'creation_to' => 'creationTo',
'template' => 'template'    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'max_hits' => 'setMaxHits',
'type' => 'setType',
'expression' => 'setExpression',
'name' => 'setName',
'description' => 'setDescription',
'top_operator' => 'setTopOperator',
'case_sensitive' => 'setCaseSensitive',
'retrieve_aliases' => 'setRetrieveAliases',
'filter_ids' => 'setFilterIds',
'folder_id' => 'setFolderId',
'search_in_sub_path' => 'setSearchInSubPath',
'expression_language' => 'setExpressionLanguage',
'size_min' => 'setSizeMin',
'size_max' => 'setSizeMax',
'format' => 'setFormat',
'fields' => 'setFields',
'language' => 'setLanguage',
'date_from' => 'setDateFrom',
'date_to' => 'setDateTo',
'creation_from' => 'setCreationFrom',
'creation_to' => 'setCreationTo',
'template' => 'setTemplate'    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'max_hits' => 'getMaxHits',
'type' => 'getType',
'expression' => 'getExpression',
'name' => 'getName',
'description' => 'getDescription',
'top_operator' => 'getTopOperator',
'case_sensitive' => 'getCaseSensitive',
'retrieve_aliases' => 'getRetrieveAliases',
'filter_ids' => 'getFilterIds',
'folder_id' => 'getFolderId',
'search_in_sub_path' => 'getSearchInSubPath',
'expression_language' => 'getExpressionLanguage',
'size_min' => 'getSizeMin',
'size_max' => 'getSizeMax',
'format' => 'getFormat',
'fields' => 'getFields',
'language' => 'getLanguage',
'date_from' => 'getDateFrom',
'date_to' => 'getDateTo',
'creation_from' => 'getCreationFrom',
'creation_to' => 'getCreationTo',
'template' => 'getTemplate'    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['max_hits'] = isset($data['max_hits']) ? $data['max_hits'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['expression'] = isset($data['expression']) ? $data['expression'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['top_operator'] = isset($data['top_operator']) ? $data['top_operator'] : null;
        $this->container['case_sensitive'] = isset($data['case_sensitive']) ? $data['case_sensitive'] : null;
        $this->container['retrieve_aliases'] = isset($data['retrieve_aliases']) ? $data['retrieve_aliases'] : null;
        $this->container['filter_ids'] = isset($data['filter_ids']) ? $data['filter_ids'] : null;
        $this->container['folder_id'] = isset($data['folder_id']) ? $data['folder_id'] : null;
        $this->container['search_in_sub_path'] = isset($data['search_in_sub_path']) ? $data['search_in_sub_path'] : null;
        $this->container['expression_language'] = isset($data['expression_language']) ? $data['expression_language'] : null;
        $this->container['size_min'] = isset($data['size_min']) ? $data['size_min'] : null;
        $this->container['size_max'] = isset($data['size_max']) ? $data['size_max'] : null;
        $this->container['format'] = isset($data['format']) ? $data['format'] : null;
        $this->container['fields'] = isset($data['fields']) ? $data['fields'] : null;
        $this->container['language'] = isset($data['language']) ? $data['language'] : null;
        $this->container['date_from'] = isset($data['date_from']) ? $data['date_from'] : null;
        $this->container['date_to'] = isset($data['date_to']) ? $data['date_to'] : null;
        $this->container['creation_from'] = isset($data['creation_from']) ? $data['creation_from'] : null;
        $this->container['creation_to'] = isset($data['creation_to']) ? $data['creation_to'] : null;
        $this->container['template'] = isset($data['template']) ? $data['template'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets max_hits
     *
     * @return int
     */
    public function getMaxHits()
    {
        return $this->container['max_hits'];
    }

    /**
     * Sets max_hits
     *
     * @param int $max_hits max_hits
     *
     * @return $this
     */
    public function setMaxHits($max_hits)
    {
        $this->container['max_hits'] = $max_hits;

        return $this;
    }

    /**
     * Gets type
     *
     * @return int
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param int $type type
     *
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets expression
     *
     * @return string
     */
    public function getExpression()
    {
        return $this->container['expression'];
    }

    /**
     * Sets expression
     *
     * @param string $expression expression
     *
     * @return $this
     */
    public function setExpression($expression)
    {
        $this->container['expression'] = $expression;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description description
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets top_operator
     *
     * @return string
     */
    public function getTopOperator()
    {
        return $this->container['top_operator'];
    }

    /**
     * Sets top_operator
     *
     * @param string $top_operator top_operator
     *
     * @return $this
     */
    public function setTopOperator($top_operator)
    {
        $this->container['top_operator'] = $top_operator;

        return $this;
    }

    /**
     * Gets case_sensitive
     *
     * @return int
     */
    public function getCaseSensitive()
    {
        return $this->container['case_sensitive'];
    }

    /**
     * Sets case_sensitive
     *
     * @param int $case_sensitive case_sensitive
     *
     * @return $this
     */
    public function setCaseSensitive($case_sensitive)
    {
        $this->container['case_sensitive'] = $case_sensitive;

        return $this;
    }

    /**
     * Gets retrieve_aliases
     *
     * @return int
     */
    public function getRetrieveAliases()
    {
        return $this->container['retrieve_aliases'];
    }

    /**
     * Sets retrieve_aliases
     *
     * @param int $retrieve_aliases retrieve_aliases
     *
     * @return $this
     */
    public function setRetrieveAliases($retrieve_aliases)
    {
        $this->container['retrieve_aliases'] = $retrieve_aliases;

        return $this;
    }

    /**
     * Gets filter_ids
     *
     * @return int[]
     */
    public function getFilterIds()
    {
        return $this->container['filter_ids'];
    }

    /**
     * Sets filter_ids
     *
     * @param int[] $filter_ids filter_ids
     *
     * @return $this
     */
    public function setFilterIds($filter_ids)
    {
        $this->container['filter_ids'] = $filter_ids;

        return $this;
    }

    /**
     * Gets folder_id
     *
     * @return int
     */
    public function getFolderId()
    {
        return $this->container['folder_id'];
    }

    /**
     * Sets folder_id
     *
     * @param int $folder_id folder_id
     *
     * @return $this
     */
    public function setFolderId($folder_id)
    {
        $this->container['folder_id'] = $folder_id;

        return $this;
    }

    /**
     * Gets search_in_sub_path
     *
     * @return int
     */
    public function getSearchInSubPath()
    {
        return $this->container['search_in_sub_path'];
    }

    /**
     * Sets search_in_sub_path
     *
     * @param int $search_in_sub_path search_in_sub_path
     *
     * @return $this
     */
    public function setSearchInSubPath($search_in_sub_path)
    {
        $this->container['search_in_sub_path'] = $search_in_sub_path;

        return $this;
    }

    /**
     * Gets expression_language
     *
     * @return string
     */
    public function getExpressionLanguage()
    {
        return $this->container['expression_language'];
    }

    /**
     * Sets expression_language
     *
     * @param string $expression_language expression_language
     *
     * @return $this
     */
    public function setExpressionLanguage($expression_language)
    {
        $this->container['expression_language'] = $expression_language;

        return $this;
    }

    /**
     * Gets size_min
     *
     * @return int
     */
    public function getSizeMin()
    {
        return $this->container['size_min'];
    }

    /**
     * Sets size_min
     *
     * @param int $size_min size_min
     *
     * @return $this
     */
    public function setSizeMin($size_min)
    {
        $this->container['size_min'] = $size_min;

        return $this;
    }

    /**
     * Gets size_max
     *
     * @return int
     */
    public function getSizeMax()
    {
        return $this->container['size_max'];
    }

    /**
     * Sets size_max
     *
     * @param int $size_max size_max
     *
     * @return $this
     */
    public function setSizeMax($size_max)
    {
        $this->container['size_max'] = $size_max;

        return $this;
    }

    /**
     * Gets format
     *
     * @return string
     */
    public function getFormat()
    {
        return $this->container['format'];
    }

    /**
     * Sets format
     *
     * @param string $format format
     *
     * @return $this
     */
    public function setFormat($format)
    {
        $this->container['format'] = $format;

        return $this;
    }

    /**
     * Gets fields
     *
     * @return string[]
     */
    public function getFields()
    {
        return $this->container['fields'];
    }

    /**
     * Sets fields
     *
     * @param string[] $fields fields
     *
     * @return $this
     */
    public function setFields($fields)
    {
        $this->container['fields'] = $fields;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string $language language
     *
     * @return $this
     */
    public function setLanguage($language)
    {
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets date_from
     *
     * @return string
     */
    public function getDateFrom()
    {
        return $this->container['date_from'];
    }

    /**
     * Sets date_from
     *
     * @param string $date_from date_from
     *
     * @return $this
     */
    public function setDateFrom($date_from)
    {
        $this->container['date_from'] = $date_from;

        return $this;
    }

    /**
     * Gets date_to
     *
     * @return string
     */
    public function getDateTo()
    {
        return $this->container['date_to'];
    }

    /**
     * Sets date_to
     *
     * @param string $date_to date_to
     *
     * @return $this
     */
    public function setDateTo($date_to)
    {
        $this->container['date_to'] = $date_to;

        return $this;
    }

    /**
     * Gets creation_from
     *
     * @return string
     */
    public function getCreationFrom()
    {
        return $this->container['creation_from'];
    }

    /**
     * Sets creation_from
     *
     * @param string $creation_from creation_from
     *
     * @return $this
     */
    public function setCreationFrom($creation_from)
    {
        $this->container['creation_from'] = $creation_from;

        return $this;
    }

    /**
     * Gets creation_to
     *
     * @return string
     */
    public function getCreationTo()
    {
        return $this->container['creation_to'];
    }

    /**
     * Sets creation_to
     *
     * @param string $creation_to creation_to
     *
     * @return $this
     */
    public function setCreationTo($creation_to)
    {
        $this->container['creation_to'] = $creation_to;

        return $this;
    }

    /**
     * Gets template
     *
     * @return int
     */
    public function getTemplate()
    {
        return $this->container['template'];
    }

    /**
     * Sets template
     *
     * @param int $template template
     *
     * @return $this
     */
    public function setTemplate($template)
    {
        $this->container['template'] = $template;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
