<?php
/**
 * @license    License compatible with GNU General Public License (GNU GPL); see file LICENSE
 */

/**
 * InlineResponseDefaultTransferDataFlavors
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * LogicalDOC REST API
 *
 * This is the interactive documentation of the REST APIs exposed by LogicalDOC. You can find more information about LogicalDOC at <a href=\"https://www.logicaldoc.com\">https://www.logicaldoc.com</a> or on Twitter @logicaldoc.<br/>                Note: The access path to the API is protected with basic authentication, to be able to run the samples you must log in using the credentials of a Logicaldoc user, or passing to the request the session ID (SID) as a cookie (cookie name: `ldoc-sid`).<br/><br/>             Here is an example to list the children folders: <br/> <pre>curl -u admin:admin -H 'Accept: application/json' http://localhost:8080/services/rest/folder/listChildren?folderId=4</pre><br/><br/>RESTful Guide with curl:  <a href='https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl'>https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl</a> <br/><br/>Practical examples of use are available for various programming languages at: <a href='http://wiki.logicaldoc.com/wiki/Bindings_And_Samples'>http://wiki.logicaldoc.com/wiki/Bindings_And_Samples</a>
 *
 * OpenAPI spec version: 8.6.0-oas3
 * Contact: devel@logicaldoc.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.33
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

defined('_JEXEC') or die('Restricted access');


use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * InlineResponseDefaultTransferDataFlavors Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class InlineResponseDefaultTransferDataFlavors implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'inline_response_default_transferDataFlavors';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'mime_type' => 'string',
'human_presentable_name' => 'string',
'primary_type' => 'string',
'sub_type' => 'string',
'mime_type_serialized_object' => 'bool',
'default_representation_class_as_string' => 'string',
'representation_class_input_stream' => 'bool',
'representation_class_reader' => 'bool',
'representation_class_char_buffer' => 'bool',
'representation_class_byte_buffer' => 'bool',
'representation_class_serializable' => 'bool',
'representation_class_remote' => 'bool',
'flavor_serialized_object_type' => 'bool',
'flavor_remote_object_type' => 'bool',
'flavor_java_file_list_type' => 'bool',
'flavor_text_type' => 'bool'    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'mime_type' => null,
'human_presentable_name' => null,
'primary_type' => null,
'sub_type' => null,
'mime_type_serialized_object' => null,
'default_representation_class_as_string' => null,
'representation_class_input_stream' => null,
'representation_class_reader' => null,
'representation_class_char_buffer' => null,
'representation_class_byte_buffer' => null,
'representation_class_serializable' => null,
'representation_class_remote' => null,
'flavor_serialized_object_type' => null,
'flavor_remote_object_type' => null,
'flavor_java_file_list_type' => null,
'flavor_text_type' => null    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'mime_type' => 'mimeType',
'human_presentable_name' => 'humanPresentableName',
'primary_type' => 'primaryType',
'sub_type' => 'subType',
'mime_type_serialized_object' => 'mimeTypeSerializedObject',
'default_representation_class_as_string' => 'defaultRepresentationClassAsString',
'representation_class_input_stream' => 'representationClassInputStream',
'representation_class_reader' => 'representationClassReader',
'representation_class_char_buffer' => 'representationClassCharBuffer',
'representation_class_byte_buffer' => 'representationClassByteBuffer',
'representation_class_serializable' => 'representationClassSerializable',
'representation_class_remote' => 'representationClassRemote',
'flavor_serialized_object_type' => 'flavorSerializedObjectType',
'flavor_remote_object_type' => 'flavorRemoteObjectType',
'flavor_java_file_list_type' => 'flavorJavaFileListType',
'flavor_text_type' => 'flavorTextType'    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'mime_type' => 'setMimeType',
'human_presentable_name' => 'setHumanPresentableName',
'primary_type' => 'setPrimaryType',
'sub_type' => 'setSubType',
'mime_type_serialized_object' => 'setMimeTypeSerializedObject',
'default_representation_class_as_string' => 'setDefaultRepresentationClassAsString',
'representation_class_input_stream' => 'setRepresentationClassInputStream',
'representation_class_reader' => 'setRepresentationClassReader',
'representation_class_char_buffer' => 'setRepresentationClassCharBuffer',
'representation_class_byte_buffer' => 'setRepresentationClassByteBuffer',
'representation_class_serializable' => 'setRepresentationClassSerializable',
'representation_class_remote' => 'setRepresentationClassRemote',
'flavor_serialized_object_type' => 'setFlavorSerializedObjectType',
'flavor_remote_object_type' => 'setFlavorRemoteObjectType',
'flavor_java_file_list_type' => 'setFlavorJavaFileListType',
'flavor_text_type' => 'setFlavorTextType'    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'mime_type' => 'getMimeType',
'human_presentable_name' => 'getHumanPresentableName',
'primary_type' => 'getPrimaryType',
'sub_type' => 'getSubType',
'mime_type_serialized_object' => 'getMimeTypeSerializedObject',
'default_representation_class_as_string' => 'getDefaultRepresentationClassAsString',
'representation_class_input_stream' => 'getRepresentationClassInputStream',
'representation_class_reader' => 'getRepresentationClassReader',
'representation_class_char_buffer' => 'getRepresentationClassCharBuffer',
'representation_class_byte_buffer' => 'getRepresentationClassByteBuffer',
'representation_class_serializable' => 'getRepresentationClassSerializable',
'representation_class_remote' => 'getRepresentationClassRemote',
'flavor_serialized_object_type' => 'getFlavorSerializedObjectType',
'flavor_remote_object_type' => 'getFlavorRemoteObjectType',
'flavor_java_file_list_type' => 'getFlavorJavaFileListType',
'flavor_text_type' => 'getFlavorTextType'    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['mime_type'] = isset($data['mime_type']) ? $data['mime_type'] : null;
        $this->container['human_presentable_name'] = isset($data['human_presentable_name']) ? $data['human_presentable_name'] : null;
        $this->container['primary_type'] = isset($data['primary_type']) ? $data['primary_type'] : null;
        $this->container['sub_type'] = isset($data['sub_type']) ? $data['sub_type'] : null;
        $this->container['mime_type_serialized_object'] = isset($data['mime_type_serialized_object']) ? $data['mime_type_serialized_object'] : null;
        $this->container['default_representation_class_as_string'] = isset($data['default_representation_class_as_string']) ? $data['default_representation_class_as_string'] : null;
        $this->container['representation_class_input_stream'] = isset($data['representation_class_input_stream']) ? $data['representation_class_input_stream'] : null;
        $this->container['representation_class_reader'] = isset($data['representation_class_reader']) ? $data['representation_class_reader'] : null;
        $this->container['representation_class_char_buffer'] = isset($data['representation_class_char_buffer']) ? $data['representation_class_char_buffer'] : null;
        $this->container['representation_class_byte_buffer'] = isset($data['representation_class_byte_buffer']) ? $data['representation_class_byte_buffer'] : null;
        $this->container['representation_class_serializable'] = isset($data['representation_class_serializable']) ? $data['representation_class_serializable'] : null;
        $this->container['representation_class_remote'] = isset($data['representation_class_remote']) ? $data['representation_class_remote'] : null;
        $this->container['flavor_serialized_object_type'] = isset($data['flavor_serialized_object_type']) ? $data['flavor_serialized_object_type'] : null;
        $this->container['flavor_remote_object_type'] = isset($data['flavor_remote_object_type']) ? $data['flavor_remote_object_type'] : null;
        $this->container['flavor_java_file_list_type'] = isset($data['flavor_java_file_list_type']) ? $data['flavor_java_file_list_type'] : null;
        $this->container['flavor_text_type'] = isset($data['flavor_text_type']) ? $data['flavor_text_type'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets mime_type
     *
     * @return string
     */
    public function getMimeType()
    {
        return $this->container['mime_type'];
    }

    /**
     * Sets mime_type
     *
     * @param string $mime_type mime_type
     *
     * @return $this
     */
    public function setMimeType($mime_type)
    {
        $this->container['mime_type'] = $mime_type;

        return $this;
    }

    /**
     * Gets human_presentable_name
     *
     * @return string
     */
    public function getHumanPresentableName()
    {
        return $this->container['human_presentable_name'];
    }

    /**
     * Sets human_presentable_name
     *
     * @param string $human_presentable_name human_presentable_name
     *
     * @return $this
     */
    public function setHumanPresentableName($human_presentable_name)
    {
        $this->container['human_presentable_name'] = $human_presentable_name;

        return $this;
    }

    /**
     * Gets primary_type
     *
     * @return string
     */
    public function getPrimaryType()
    {
        return $this->container['primary_type'];
    }

    /**
     * Sets primary_type
     *
     * @param string $primary_type primary_type
     *
     * @return $this
     */
    public function setPrimaryType($primary_type)
    {
        $this->container['primary_type'] = $primary_type;

        return $this;
    }

    /**
     * Gets sub_type
     *
     * @return string
     */
    public function getSubType()
    {
        return $this->container['sub_type'];
    }

    /**
     * Sets sub_type
     *
     * @param string $sub_type sub_type
     *
     * @return $this
     */
    public function setSubType($sub_type)
    {
        $this->container['sub_type'] = $sub_type;

        return $this;
    }

    /**
     * Gets mime_type_serialized_object
     *
     * @return bool
     */
    public function getMimeTypeSerializedObject()
    {
        return $this->container['mime_type_serialized_object'];
    }

    /**
     * Sets mime_type_serialized_object
     *
     * @param bool $mime_type_serialized_object mime_type_serialized_object
     *
     * @return $this
     */
    public function setMimeTypeSerializedObject($mime_type_serialized_object)
    {
        $this->container['mime_type_serialized_object'] = $mime_type_serialized_object;

        return $this;
    }

    /**
     * Gets default_representation_class_as_string
     *
     * @return string
     */
    public function getDefaultRepresentationClassAsString()
    {
        return $this->container['default_representation_class_as_string'];
    }

    /**
     * Sets default_representation_class_as_string
     *
     * @param string $default_representation_class_as_string default_representation_class_as_string
     *
     * @return $this
     */
    public function setDefaultRepresentationClassAsString($default_representation_class_as_string)
    {
        $this->container['default_representation_class_as_string'] = $default_representation_class_as_string;

        return $this;
    }

    /**
     * Gets representation_class_input_stream
     *
     * @return bool
     */
    public function getRepresentationClassInputStream()
    {
        return $this->container['representation_class_input_stream'];
    }

    /**
     * Sets representation_class_input_stream
     *
     * @param bool $representation_class_input_stream representation_class_input_stream
     *
     * @return $this
     */
    public function setRepresentationClassInputStream($representation_class_input_stream)
    {
        $this->container['representation_class_input_stream'] = $representation_class_input_stream;

        return $this;
    }

    /**
     * Gets representation_class_reader
     *
     * @return bool
     */
    public function getRepresentationClassReader()
    {
        return $this->container['representation_class_reader'];
    }

    /**
     * Sets representation_class_reader
     *
     * @param bool $representation_class_reader representation_class_reader
     *
     * @return $this
     */
    public function setRepresentationClassReader($representation_class_reader)
    {
        $this->container['representation_class_reader'] = $representation_class_reader;

        return $this;
    }

    /**
     * Gets representation_class_char_buffer
     *
     * @return bool
     */
    public function getRepresentationClassCharBuffer()
    {
        return $this->container['representation_class_char_buffer'];
    }

    /**
     * Sets representation_class_char_buffer
     *
     * @param bool $representation_class_char_buffer representation_class_char_buffer
     *
     * @return $this
     */
    public function setRepresentationClassCharBuffer($representation_class_char_buffer)
    {
        $this->container['representation_class_char_buffer'] = $representation_class_char_buffer;

        return $this;
    }

    /**
     * Gets representation_class_byte_buffer
     *
     * @return bool
     */
    public function getRepresentationClassByteBuffer()
    {
        return $this->container['representation_class_byte_buffer'];
    }

    /**
     * Sets representation_class_byte_buffer
     *
     * @param bool $representation_class_byte_buffer representation_class_byte_buffer
     *
     * @return $this
     */
    public function setRepresentationClassByteBuffer($representation_class_byte_buffer)
    {
        $this->container['representation_class_byte_buffer'] = $representation_class_byte_buffer;

        return $this;
    }

    /**
     * Gets representation_class_serializable
     *
     * @return bool
     */
    public function getRepresentationClassSerializable()
    {
        return $this->container['representation_class_serializable'];
    }

    /**
     * Sets representation_class_serializable
     *
     * @param bool $representation_class_serializable representation_class_serializable
     *
     * @return $this
     */
    public function setRepresentationClassSerializable($representation_class_serializable)
    {
        $this->container['representation_class_serializable'] = $representation_class_serializable;

        return $this;
    }

    /**
     * Gets representation_class_remote
     *
     * @return bool
     */
    public function getRepresentationClassRemote()
    {
        return $this->container['representation_class_remote'];
    }

    /**
     * Sets representation_class_remote
     *
     * @param bool $representation_class_remote representation_class_remote
     *
     * @return $this
     */
    public function setRepresentationClassRemote($representation_class_remote)
    {
        $this->container['representation_class_remote'] = $representation_class_remote;

        return $this;
    }

    /**
     * Gets flavor_serialized_object_type
     *
     * @return bool
     */
    public function getFlavorSerializedObjectType()
    {
        return $this->container['flavor_serialized_object_type'];
    }

    /**
     * Sets flavor_serialized_object_type
     *
     * @param bool $flavor_serialized_object_type flavor_serialized_object_type
     *
     * @return $this
     */
    public function setFlavorSerializedObjectType($flavor_serialized_object_type)
    {
        $this->container['flavor_serialized_object_type'] = $flavor_serialized_object_type;

        return $this;
    }

    /**
     * Gets flavor_remote_object_type
     *
     * @return bool
     */
    public function getFlavorRemoteObjectType()
    {
        return $this->container['flavor_remote_object_type'];
    }

    /**
     * Sets flavor_remote_object_type
     *
     * @param bool $flavor_remote_object_type flavor_remote_object_type
     *
     * @return $this
     */
    public function setFlavorRemoteObjectType($flavor_remote_object_type)
    {
        $this->container['flavor_remote_object_type'] = $flavor_remote_object_type;

        return $this;
    }

    /**
     * Gets flavor_java_file_list_type
     *
     * @return bool
     */
    public function getFlavorJavaFileListType()
    {
        return $this->container['flavor_java_file_list_type'];
    }

    /**
     * Sets flavor_java_file_list_type
     *
     * @param bool $flavor_java_file_list_type flavor_java_file_list_type
     *
     * @return $this
     */
    public function setFlavorJavaFileListType($flavor_java_file_list_type)
    {
        $this->container['flavor_java_file_list_type'] = $flavor_java_file_list_type;

        return $this;
    }

    /**
     * Gets flavor_text_type
     *
     * @return bool
     */
    public function getFlavorTextType()
    {
        return $this->container['flavor_text_type'];
    }

    /**
     * Sets flavor_text_type
     *
     * @param bool $flavor_text_type flavor_text_type
     *
     * @return $this
     */
    public function setFlavorTextType($flavor_text_type)
    {
        $this->container['flavor_text_type'] = $flavor_text_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
