<?php
/**
 * @license    License compatible with GNU General Public License (GNU GPL); see file LICENSE
 */

/**
 * WSDocument
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * LogicalDOC REST API
 *
 * This is the interactive documentation of the REST APIs exposed by LogicalDOC. You can find more information about LogicalDOC at <a href=\"https://www.logicaldoc.com\">https://www.logicaldoc.com</a> or on Twitter @logicaldoc.<br/>                Note: The access path to the API is protected with basic authentication, to be able to run the samples you must log in using the credentials of a Logicaldoc user, or passing to the request the session ID (SID) as a cookie (cookie name: `ldoc-sid`).<br/><br/>             Here is an example to list the children folders: <br/> <pre>curl -u admin:admin -H 'Accept: application/json' http://localhost:8080/services/rest/folder/listChildren?folderId=4</pre><br/><br/>RESTful Guide with curl:  <a href='https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl'>https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl</a> <br/><br/>Practical examples of use are available for various programming languages at: <a href='http://wiki.logicaldoc.com/wiki/Bindings_And_Samples'>http://wiki.logicaldoc.com/wiki/Bindings_And_Samples</a>
 *
 * OpenAPI spec version: 8.6.0-oas3
 * Contact: devel@logicaldoc.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.33
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

defined('_JEXEC') or die('Restricted access');


use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * WSDocument Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class WSDocument implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'WSDocument';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'id' => 'int',
'file_size' => 'int',
'status' => 'int',
'export_status' => 'int',
'version' => 'string',
'file_version' => 'string',
'date' => 'string',
'publisher' => 'string',
'publisher_id' => 'int',
'creator' => 'string',
'creator_id' => 'int',
'type' => 'string',
'lock_user_id' => 'int',
'creation' => 'string',
'file_name' => 'string',
'indexed' => 'int',
'signed' => 'int',
'stamped' => 'int',
'tags' => 'string[]',
'folder_id' => 'int',
'template_id' => 'int',
'custom_id' => 'string',
'immutable' => 'int',
'digest' => 'string',
'export_name' => 'string',
'export_id' => 'int',
'doc_ref' => 'int',
'doc_ref_type' => 'string',
'delete_user_id' => 'int',
'attributes' => '\Swagger\Client\Model\WSAttribute[]',
'language' => 'string',
'summary' => 'string',
'score' => 'int',
'icon' => 'string',
'comment' => 'string',
'last_modified' => 'string',
'rating' => 'int',
'workflow_status' => 'string',
'workflow_status_display' => 'string',
'published' => 'int',
'start_publishing' => 'string',
'stop_publishing' => 'string',
'pages' => 'int',
'nature' => 'int',
'form_id' => 'int',
'password_protected' => 'int',
'ocr_template_id' => 'int',
'ocrd' => 'int',
'barcode_template_id' => 'int',
'barcoded' => 'int'    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'id' => 'int64',
'file_size' => 'int64',
'status' => 'int32',
'export_status' => 'int32',
'version' => null,
'file_version' => null,
'date' => null,
'publisher' => null,
'publisher_id' => 'int64',
'creator' => null,
'creator_id' => 'int64',
'type' => null,
'lock_user_id' => 'int64',
'creation' => null,
'file_name' => null,
'indexed' => 'int32',
'signed' => 'int32',
'stamped' => 'int32',
'tags' => null,
'folder_id' => 'int64',
'template_id' => 'int64',
'custom_id' => null,
'immutable' => 'int32',
'digest' => null,
'export_name' => null,
'export_id' => 'int64',
'doc_ref' => 'int64',
'doc_ref_type' => null,
'delete_user_id' => 'int64',
'attributes' => null,
'language' => null,
'summary' => null,
'score' => 'int32',
'icon' => null,
'comment' => null,
'last_modified' => null,
'rating' => 'int32',
'workflow_status' => null,
'workflow_status_display' => null,
'published' => 'int32',
'start_publishing' => null,
'stop_publishing' => null,
'pages' => 'int32',
'nature' => 'int32',
'form_id' => 'int64',
'password_protected' => 'int32',
'ocr_template_id' => 'int64',
'ocrd' => 'int32',
'barcode_template_id' => 'int64',
'barcoded' => 'int32'    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
'file_size' => 'fileSize',
'status' => 'status',
'export_status' => 'exportStatus',
'version' => 'version',
'file_version' => 'fileVersion',
'date' => 'date',
'publisher' => 'publisher',
'publisher_id' => 'publisherId',
'creator' => 'creator',
'creator_id' => 'creatorId',
'type' => 'type',
'lock_user_id' => 'lockUserId',
'creation' => 'creation',
'file_name' => 'fileName',
'indexed' => 'indexed',
'signed' => 'signed',
'stamped' => 'stamped',
'tags' => 'tags',
'folder_id' => 'folderId',
'template_id' => 'templateId',
'custom_id' => 'customId',
'immutable' => 'immutable',
'digest' => 'digest',
'export_name' => 'exportName',
'export_id' => 'exportId',
'doc_ref' => 'docRef',
'doc_ref_type' => 'docRefType',
'delete_user_id' => 'deleteUserId',
'attributes' => 'attributes',
'language' => 'language',
'summary' => 'summary',
'score' => 'score',
'icon' => 'icon',
'comment' => 'comment',
'last_modified' => 'lastModified',
'rating' => 'rating',
'workflow_status' => 'workflowStatus',
'workflow_status_display' => 'workflowStatusDisplay',
'published' => 'published',
'start_publishing' => 'startPublishing',
'stop_publishing' => 'stopPublishing',
'pages' => 'pages',
'nature' => 'nature',
'form_id' => 'formId',
'password_protected' => 'passwordProtected',
'ocr_template_id' => 'ocrTemplateId',
'ocrd' => 'ocrd',
'barcode_template_id' => 'barcodeTemplateId',
'barcoded' => 'barcoded'    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
'file_size' => 'setFileSize',
'status' => 'setStatus',
'export_status' => 'setExportStatus',
'version' => 'setVersion',
'file_version' => 'setFileVersion',
'date' => 'setDate',
'publisher' => 'setPublisher',
'publisher_id' => 'setPublisherId',
'creator' => 'setCreator',
'creator_id' => 'setCreatorId',
'type' => 'setType',
'lock_user_id' => 'setLockUserId',
'creation' => 'setCreation',
'file_name' => 'setFileName',
'indexed' => 'setIndexed',
'signed' => 'setSigned',
'stamped' => 'setStamped',
'tags' => 'setTags',
'folder_id' => 'setFolderId',
'template_id' => 'setTemplateId',
'custom_id' => 'setCustomId',
'immutable' => 'setImmutable',
'digest' => 'setDigest',
'export_name' => 'setExportName',
'export_id' => 'setExportId',
'doc_ref' => 'setDocRef',
'doc_ref_type' => 'setDocRefType',
'delete_user_id' => 'setDeleteUserId',
'attributes' => 'setAttributes',
'language' => 'setLanguage',
'summary' => 'setSummary',
'score' => 'setScore',
'icon' => 'setIcon',
'comment' => 'setComment',
'last_modified' => 'setLastModified',
'rating' => 'setRating',
'workflow_status' => 'setWorkflowStatus',
'workflow_status_display' => 'setWorkflowStatusDisplay',
'published' => 'setPublished',
'start_publishing' => 'setStartPublishing',
'stop_publishing' => 'setStopPublishing',
'pages' => 'setPages',
'nature' => 'setNature',
'form_id' => 'setFormId',
'password_protected' => 'setPasswordProtected',
'ocr_template_id' => 'setOcrTemplateId',
'ocrd' => 'setOcrd',
'barcode_template_id' => 'setBarcodeTemplateId',
'barcoded' => 'setBarcoded'    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
'file_size' => 'getFileSize',
'status' => 'getStatus',
'export_status' => 'getExportStatus',
'version' => 'getVersion',
'file_version' => 'getFileVersion',
'date' => 'getDate',
'publisher' => 'getPublisher',
'publisher_id' => 'getPublisherId',
'creator' => 'getCreator',
'creator_id' => 'getCreatorId',
'type' => 'getType',
'lock_user_id' => 'getLockUserId',
'creation' => 'getCreation',
'file_name' => 'getFileName',
'indexed' => 'getIndexed',
'signed' => 'getSigned',
'stamped' => 'getStamped',
'tags' => 'getTags',
'folder_id' => 'getFolderId',
'template_id' => 'getTemplateId',
'custom_id' => 'getCustomId',
'immutable' => 'getImmutable',
'digest' => 'getDigest',
'export_name' => 'getExportName',
'export_id' => 'getExportId',
'doc_ref' => 'getDocRef',
'doc_ref_type' => 'getDocRefType',
'delete_user_id' => 'getDeleteUserId',
'attributes' => 'getAttributes',
'language' => 'getLanguage',
'summary' => 'getSummary',
'score' => 'getScore',
'icon' => 'getIcon',
'comment' => 'getComment',
'last_modified' => 'getLastModified',
'rating' => 'getRating',
'workflow_status' => 'getWorkflowStatus',
'workflow_status_display' => 'getWorkflowStatusDisplay',
'published' => 'getPublished',
'start_publishing' => 'getStartPublishing',
'stop_publishing' => 'getStopPublishing',
'pages' => 'getPages',
'nature' => 'getNature',
'form_id' => 'getFormId',
'password_protected' => 'getPasswordProtected',
'ocr_template_id' => 'getOcrTemplateId',
'ocrd' => 'getOcrd',
'barcode_template_id' => 'getBarcodeTemplateId',
'barcoded' => 'getBarcoded'    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['file_size'] = isset($data['file_size']) ? $data['file_size'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['export_status'] = isset($data['export_status']) ? $data['export_status'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['file_version'] = isset($data['file_version']) ? $data['file_version'] : null;
        $this->container['date'] = isset($data['date']) ? $data['date'] : null;
        $this->container['publisher'] = isset($data['publisher']) ? $data['publisher'] : null;
        $this->container['publisher_id'] = isset($data['publisher_id']) ? $data['publisher_id'] : null;
        $this->container['creator'] = isset($data['creator']) ? $data['creator'] : null;
        $this->container['creator_id'] = isset($data['creator_id']) ? $data['creator_id'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['lock_user_id'] = isset($data['lock_user_id']) ? $data['lock_user_id'] : null;
        $this->container['creation'] = isset($data['creation']) ? $data['creation'] : null;
        $this->container['file_name'] = isset($data['file_name']) ? $data['file_name'] : null;
        $this->container['indexed'] = isset($data['indexed']) ? $data['indexed'] : null;
        $this->container['signed'] = isset($data['signed']) ? $data['signed'] : null;
        $this->container['stamped'] = isset($data['stamped']) ? $data['stamped'] : null;
        $this->container['tags'] = isset($data['tags']) ? $data['tags'] : null;
        $this->container['folder_id'] = isset($data['folder_id']) ? $data['folder_id'] : null;
        $this->container['template_id'] = isset($data['template_id']) ? $data['template_id'] : null;
        $this->container['custom_id'] = isset($data['custom_id']) ? $data['custom_id'] : null;
        $this->container['immutable'] = isset($data['immutable']) ? $data['immutable'] : null;
        $this->container['digest'] = isset($data['digest']) ? $data['digest'] : null;
        $this->container['export_name'] = isset($data['export_name']) ? $data['export_name'] : null;
        $this->container['export_id'] = isset($data['export_id']) ? $data['export_id'] : null;
        $this->container['doc_ref'] = isset($data['doc_ref']) ? $data['doc_ref'] : null;
        $this->container['doc_ref_type'] = isset($data['doc_ref_type']) ? $data['doc_ref_type'] : null;
        $this->container['delete_user_id'] = isset($data['delete_user_id']) ? $data['delete_user_id'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['language'] = isset($data['language']) ? $data['language'] : null;
        $this->container['summary'] = isset($data['summary']) ? $data['summary'] : null;
        $this->container['score'] = isset($data['score']) ? $data['score'] : null;
        $this->container['icon'] = isset($data['icon']) ? $data['icon'] : null;
        $this->container['comment'] = isset($data['comment']) ? $data['comment'] : null;
        $this->container['last_modified'] = isset($data['last_modified']) ? $data['last_modified'] : null;
        $this->container['rating'] = isset($data['rating']) ? $data['rating'] : null;
        $this->container['workflow_status'] = isset($data['workflow_status']) ? $data['workflow_status'] : null;
        $this->container['workflow_status_display'] = isset($data['workflow_status_display']) ? $data['workflow_status_display'] : null;
        $this->container['published'] = isset($data['published']) ? $data['published'] : null;
        $this->container['start_publishing'] = isset($data['start_publishing']) ? $data['start_publishing'] : null;
        $this->container['stop_publishing'] = isset($data['stop_publishing']) ? $data['stop_publishing'] : null;
        $this->container['pages'] = isset($data['pages']) ? $data['pages'] : null;
        $this->container['nature'] = isset($data['nature']) ? $data['nature'] : null;
        $this->container['form_id'] = isset($data['form_id']) ? $data['form_id'] : null;
        $this->container['password_protected'] = isset($data['password_protected']) ? $data['password_protected'] : null;
        $this->container['ocr_template_id'] = isset($data['ocr_template_id']) ? $data['ocr_template_id'] : null;
        $this->container['ocrd'] = isset($data['ocrd']) ? $data['ocrd'] : null;
        $this->container['barcode_template_id'] = isset($data['barcode_template_id']) ? $data['barcode_template_id'] : null;
        $this->container['barcoded'] = isset($data['barcoded']) ? $data['barcoded'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets file_size
     *
     * @return int
     */
    public function getFileSize()
    {
        return $this->container['file_size'];
    }

    /**
     * Sets file_size
     *
     * @param int $file_size file_size
     *
     * @return $this
     */
    public function setFileSize($file_size)
    {
        $this->container['file_size'] = $file_size;

        return $this;
    }

    /**
     * Gets status
     *
     * @return int
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param int $status status
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets export_status
     *
     * @return int
     */
    public function getExportStatus()
    {
        return $this->container['export_status'];
    }

    /**
     * Sets export_status
     *
     * @param int $export_status export_status
     *
     * @return $this
     */
    public function setExportStatus($export_status)
    {
        $this->container['export_status'] = $export_status;

        return $this;
    }

    /**
     * Gets version
     *
     * @return string
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param string $version version
     *
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets file_version
     *
     * @return string
     */
    public function getFileVersion()
    {
        return $this->container['file_version'];
    }

    /**
     * Sets file_version
     *
     * @param string $file_version file_version
     *
     * @return $this
     */
    public function setFileVersion($file_version)
    {
        $this->container['file_version'] = $file_version;

        return $this;
    }

    /**
     * Gets date
     *
     * @return string
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param string $date date
     *
     * @return $this
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets publisher
     *
     * @return string
     */
    public function getPublisher()
    {
        return $this->container['publisher'];
    }

    /**
     * Sets publisher
     *
     * @param string $publisher publisher
     *
     * @return $this
     */
    public function setPublisher($publisher)
    {
        $this->container['publisher'] = $publisher;

        return $this;
    }

    /**
     * Gets publisher_id
     *
     * @return int
     */
    public function getPublisherId()
    {
        return $this->container['publisher_id'];
    }

    /**
     * Sets publisher_id
     *
     * @param int $publisher_id publisher_id
     *
     * @return $this
     */
    public function setPublisherId($publisher_id)
    {
        $this->container['publisher_id'] = $publisher_id;

        return $this;
    }

    /**
     * Gets creator
     *
     * @return string
     */
    public function getCreator()
    {
        return $this->container['creator'];
    }

    /**
     * Sets creator
     *
     * @param string $creator creator
     *
     * @return $this
     */
    public function setCreator($creator)
    {
        $this->container['creator'] = $creator;

        return $this;
    }

    /**
     * Gets creator_id
     *
     * @return int
     */
    public function getCreatorId()
    {
        return $this->container['creator_id'];
    }

    /**
     * Sets creator_id
     *
     * @param int $creator_id creator_id
     *
     * @return $this
     */
    public function setCreatorId($creator_id)
    {
        $this->container['creator_id'] = $creator_id;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type type
     *
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets lock_user_id
     *
     * @return int
     */
    public function getLockUserId()
    {
        return $this->container['lock_user_id'];
    }

    /**
     * Sets lock_user_id
     *
     * @param int $lock_user_id lock_user_id
     *
     * @return $this
     */
    public function setLockUserId($lock_user_id)
    {
        $this->container['lock_user_id'] = $lock_user_id;

        return $this;
    }

    /**
     * Gets creation
     *
     * @return string
     */
    public function getCreation()
    {
        return $this->container['creation'];
    }

    /**
     * Sets creation
     *
     * @param string $creation creation
     *
     * @return $this
     */
    public function setCreation($creation)
    {
        $this->container['creation'] = $creation;

        return $this;
    }

    /**
     * Gets file_name
     *
     * @return string
     */
    public function getFileName()
    {
        return $this->container['file_name'];
    }

    /**
     * Sets file_name
     *
     * @param string $file_name file_name
     *
     * @return $this
     */
    public function setFileName($file_name)
    {
        $this->container['file_name'] = $file_name;

        return $this;
    }

    /**
     * Gets indexed
     *
     * @return int
     */
    public function getIndexed()
    {
        return $this->container['indexed'];
    }

    /**
     * Sets indexed
     *
     * @param int $indexed indexed
     *
     * @return $this
     */
    public function setIndexed($indexed)
    {
        $this->container['indexed'] = $indexed;

        return $this;
    }

    /**
     * Gets signed
     *
     * @return int
     */
    public function getSigned()
    {
        return $this->container['signed'];
    }

    /**
     * Sets signed
     *
     * @param int $signed signed
     *
     * @return $this
     */
    public function setSigned($signed)
    {
        $this->container['signed'] = $signed;

        return $this;
    }

    /**
     * Gets stamped
     *
     * @return int
     */
    public function getStamped()
    {
        return $this->container['stamped'];
    }

    /**
     * Sets stamped
     *
     * @param int $stamped stamped
     *
     * @return $this
     */
    public function setStamped($stamped)
    {
        $this->container['stamped'] = $stamped;

        return $this;
    }

    /**
     * Gets tags
     *
     * @return string[]
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     *
     * @param string[] $tags tags
     *
     * @return $this
     */
    public function setTags($tags)
    {
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets folder_id
     *
     * @return int
     */
    public function getFolderId()
    {
        return $this->container['folder_id'];
    }

    /**
     * Sets folder_id
     *
     * @param int $folder_id folder_id
     *
     * @return $this
     */
    public function setFolderId($folder_id)
    {
        $this->container['folder_id'] = $folder_id;

        return $this;
    }

    /**
     * Gets template_id
     *
     * @return int
     */
    public function getTemplateId()
    {
        return $this->container['template_id'];
    }

    /**
     * Sets template_id
     *
     * @param int $template_id template_id
     *
     * @return $this
     */
    public function setTemplateId($template_id)
    {
        $this->container['template_id'] = $template_id;

        return $this;
    }

    /**
     * Gets custom_id
     *
     * @return string
     */
    public function getCustomId()
    {
        return $this->container['custom_id'];
    }

    /**
     * Sets custom_id
     *
     * @param string $custom_id custom_id
     *
     * @return $this
     */
    public function setCustomId($custom_id)
    {
        $this->container['custom_id'] = $custom_id;

        return $this;
    }

    /**
     * Gets immutable
     *
     * @return int
     */
    public function getImmutable()
    {
        return $this->container['immutable'];
    }

    /**
     * Sets immutable
     *
     * @param int $immutable immutable
     *
     * @return $this
     */
    public function setImmutable($immutable)
    {
        $this->container['immutable'] = $immutable;

        return $this;
    }

    /**
     * Gets digest
     *
     * @return string
     */
    public function getDigest()
    {
        return $this->container['digest'];
    }

    /**
     * Sets digest
     *
     * @param string $digest digest
     *
     * @return $this
     */
    public function setDigest($digest)
    {
        $this->container['digest'] = $digest;

        return $this;
    }

    /**
     * Gets export_name
     *
     * @return string
     */
    public function getExportName()
    {
        return $this->container['export_name'];
    }

    /**
     * Sets export_name
     *
     * @param string $export_name export_name
     *
     * @return $this
     */
    public function setExportName($export_name)
    {
        $this->container['export_name'] = $export_name;

        return $this;
    }

    /**
     * Gets export_id
     *
     * @return int
     */
    public function getExportId()
    {
        return $this->container['export_id'];
    }

    /**
     * Sets export_id
     *
     * @param int $export_id export_id
     *
     * @return $this
     */
    public function setExportId($export_id)
    {
        $this->container['export_id'] = $export_id;

        return $this;
    }

    /**
     * Gets doc_ref
     *
     * @return int
     */
    public function getDocRef()
    {
        return $this->container['doc_ref'];
    }

    /**
     * Sets doc_ref
     *
     * @param int $doc_ref doc_ref
     *
     * @return $this
     */
    public function setDocRef($doc_ref)
    {
        $this->container['doc_ref'] = $doc_ref;

        return $this;
    }

    /**
     * Gets doc_ref_type
     *
     * @return string
     */
    public function getDocRefType()
    {
        return $this->container['doc_ref_type'];
    }

    /**
     * Sets doc_ref_type
     *
     * @param string $doc_ref_type doc_ref_type
     *
     * @return $this
     */
    public function setDocRefType($doc_ref_type)
    {
        $this->container['doc_ref_type'] = $doc_ref_type;

        return $this;
    }

    /**
     * Gets delete_user_id
     *
     * @return int
     */
    public function getDeleteUserId()
    {
        return $this->container['delete_user_id'];
    }

    /**
     * Sets delete_user_id
     *
     * @param int $delete_user_id delete_user_id
     *
     * @return $this
     */
    public function setDeleteUserId($delete_user_id)
    {
        $this->container['delete_user_id'] = $delete_user_id;

        return $this;
    }

    /**
     * Gets attributes
     *
     * @return \Swagger\Client\Model\WSAttribute[]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     *
     * @param \Swagger\Client\Model\WSAttribute[] $attributes attributes
     *
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string $language language
     *
     * @return $this
     */
    public function setLanguage($language)
    {
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets summary
     *
     * @return string
     */
    public function getSummary()
    {
        return $this->container['summary'];
    }

    /**
     * Sets summary
     *
     * @param string $summary summary
     *
     * @return $this
     */
    public function setSummary($summary)
    {
        $this->container['summary'] = $summary;

        return $this;
    }

    /**
     * Gets score
     *
     * @return int
     */
    public function getScore()
    {
        return $this->container['score'];
    }

    /**
     * Sets score
     *
     * @param int $score score
     *
     * @return $this
     */
    public function setScore($score)
    {
        $this->container['score'] = $score;

        return $this;
    }

    /**
     * Gets icon
     *
     * @return string
     */
    public function getIcon()
    {
        return $this->container['icon'];
    }

    /**
     * Sets icon
     *
     * @param string $icon icon
     *
     * @return $this
     */
    public function setIcon($icon)
    {
        $this->container['icon'] = $icon;

        return $this;
    }

    /**
     * Gets comment
     *
     * @return string
     */
    public function getComment()
    {
        return $this->container['comment'];
    }

    /**
     * Sets comment
     *
     * @param string $comment comment
     *
     * @return $this
     */
    public function setComment($comment)
    {
        $this->container['comment'] = $comment;

        return $this;
    }

    /**
     * Gets last_modified
     *
     * @return string
     */
    public function getLastModified()
    {
        return $this->container['last_modified'];
    }

    /**
     * Sets last_modified
     *
     * @param string $last_modified last_modified
     *
     * @return $this
     */
    public function setLastModified($last_modified)
    {
        $this->container['last_modified'] = $last_modified;

        return $this;
    }

    /**
     * Gets rating
     *
     * @return int
     */
    public function getRating()
    {
        return $this->container['rating'];
    }

    /**
     * Sets rating
     *
     * @param int $rating rating
     *
     * @return $this
     */
    public function setRating($rating)
    {
        $this->container['rating'] = $rating;

        return $this;
    }

    /**
     * Gets workflow_status
     *
     * @return string
     */
    public function getWorkflowStatus()
    {
        return $this->container['workflow_status'];
    }

    /**
     * Sets workflow_status
     *
     * @param string $workflow_status workflow_status
     *
     * @return $this
     */
    public function setWorkflowStatus($workflow_status)
    {
        $this->container['workflow_status'] = $workflow_status;

        return $this;
    }

    /**
     * Gets workflow_status_display
     *
     * @return string
     */
    public function getWorkflowStatusDisplay()
    {
        return $this->container['workflow_status_display'];
    }

    /**
     * Sets workflow_status_display
     *
     * @param string $workflow_status_display workflow_status_display
     *
     * @return $this
     */
    public function setWorkflowStatusDisplay($workflow_status_display)
    {
        $this->container['workflow_status_display'] = $workflow_status_display;

        return $this;
    }

    /**
     * Gets published
     *
     * @return int
     */
    public function getPublished()
    {
        return $this->container['published'];
    }

    /**
     * Sets published
     *
     * @param int $published published
     *
     * @return $this
     */
    public function setPublished($published)
    {
        $this->container['published'] = $published;

        return $this;
    }

    /**
     * Gets start_publishing
     *
     * @return string
     */
    public function getStartPublishing()
    {
        return $this->container['start_publishing'];
    }

    /**
     * Sets start_publishing
     *
     * @param string $start_publishing start_publishing
     *
     * @return $this
     */
    public function setStartPublishing($start_publishing)
    {
        $this->container['start_publishing'] = $start_publishing;

        return $this;
    }

    /**
     * Gets stop_publishing
     *
     * @return string
     */
    public function getStopPublishing()
    {
        return $this->container['stop_publishing'];
    }

    /**
     * Sets stop_publishing
     *
     * @param string $stop_publishing stop_publishing
     *
     * @return $this
     */
    public function setStopPublishing($stop_publishing)
    {
        $this->container['stop_publishing'] = $stop_publishing;

        return $this;
    }

    /**
     * Gets pages
     *
     * @return int
     */
    public function getPages()
    {
        return $this->container['pages'];
    }

    /**
     * Sets pages
     *
     * @param int $pages pages
     *
     * @return $this
     */
    public function setPages($pages)
    {
        $this->container['pages'] = $pages;

        return $this;
    }

    /**
     * Gets nature
     *
     * @return int
     */
    public function getNature()
    {
        return $this->container['nature'];
    }

    /**
     * Sets nature
     *
     * @param int $nature nature
     *
     * @return $this
     */
    public function setNature($nature)
    {
        $this->container['nature'] = $nature;

        return $this;
    }

    /**
     * Gets form_id
     *
     * @return int
     */
    public function getFormId()
    {
        return $this->container['form_id'];
    }

    /**
     * Sets form_id
     *
     * @param int $form_id form_id
     *
     * @return $this
     */
    public function setFormId($form_id)
    {
        $this->container['form_id'] = $form_id;

        return $this;
    }

    /**
     * Gets password_protected
     *
     * @return int
     */
    public function getPasswordProtected()
    {
        return $this->container['password_protected'];
    }

    /**
     * Sets password_protected
     *
     * @param int $password_protected password_protected
     *
     * @return $this
     */
    public function setPasswordProtected($password_protected)
    {
        $this->container['password_protected'] = $password_protected;

        return $this;
    }

    /**
     * Gets ocr_template_id
     *
     * @return int
     */
    public function getOcrTemplateId()
    {
        return $this->container['ocr_template_id'];
    }

    /**
     * Sets ocr_template_id
     *
     * @param int $ocr_template_id ocr_template_id
     *
     * @return $this
     */
    public function setOcrTemplateId($ocr_template_id)
    {
        $this->container['ocr_template_id'] = $ocr_template_id;

        return $this;
    }

    /**
     * Gets ocrd
     *
     * @return int
     */
    public function getOcrd()
    {
        return $this->container['ocrd'];
    }

    /**
     * Sets ocrd
     *
     * @param int $ocrd ocrd
     *
     * @return $this
     */
    public function setOcrd($ocrd)
    {
        $this->container['ocrd'] = $ocrd;

        return $this;
    }

    /**
     * Gets barcode_template_id
     *
     * @return int
     */
    public function getBarcodeTemplateId()
    {
        return $this->container['barcode_template_id'];
    }

    /**
     * Sets barcode_template_id
     *
     * @param int $barcode_template_id barcode_template_id
     *
     * @return $this
     */
    public function setBarcodeTemplateId($barcode_template_id)
    {
        $this->container['barcode_template_id'] = $barcode_template_id;

        return $this;
    }

    /**
     * Gets barcoded
     *
     * @return int
     */
    public function getBarcoded()
    {
        return $this->container['barcoded'];
    }

    /**
     * Sets barcoded
     *
     * @param int $barcoded barcoded
     *
     * @return $this
     */
    public function setBarcoded($barcoded)
    {
        $this->container['barcoded'] = $barcoded;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
