/**
 * @package     FILEman
 * @copyright   Copyright (C) 2011 Timble CVBA. (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

"use strict";

kQuery(function($) {

  //delete items button
  var delete_items_btn = 'a[data-name="delete"]';

  //use the toolbar delete button data for all delete buttons
  var request_params = $(delete_items_btn).data('params');
  var request_action = 'delete';
  var request_prompt = $(delete_items_btn).data('prompt');

  //delete item button
  var delete_item_btn = 'a[data-action="delete-item"]';

  //checkboxes
  var item_checkbox = 'input[name="item-select"]';

  //gallery view
  if($('div.com_fileman .koowa_media--gallery').length) {

    var deletable = '.koowa_media__item__content';
    var deletable_container = '.koowa_media__item';
    var path_container = '.koowa_media__item__link';

  //table view
  } else if ($('div.com_fileman .fileman_table_layout').length) {

    var deletable = 'tr.fileman_file, tr.fileman_folder';
    var deletable_container = null;
    var path_container = '.koowa_header__item a';
  }

  $(delete_items_btn).addClass('k-is-disabled').addClass('disabled');

  $.fn.KItemDelete = function () {

      var elem = $(this);
      var item_path = elem.find(path_container).attr('href');

      if (item_path.search(/\?/) !== -1) {
          item_path += '&';
      } else {
          item_path += '?'
      }

      item_path += 'format=json';

      $.ajax({
          method : 'post',
          url : item_path,
          data : request_params,
          beforeSend : function () {
              elem.addClass('disabled');
          },
          success : function () {
              var container = elem;

              if(deletable_container){
                  container = elem.closest(deletable_container);
              }

              container.fadeOut(300, function() {
                  var wrapper = elem.closest('.koowa_media_wrapper');

                  $(this).remove();

                  if (wrapper && wrapper.data('simpleGallery')) {
                      wrapper.data('simpleGallery').refresh();
                  }
              });
          },
          error : function (xhr, textStatus, errorThrown) {
              var response = $.parseJSON(xhr.responseText, true);

              if (response && response.error) {
                  alert(response.error);
              }
          }
      });
  };

  //checkbox event handler
  $('body').on('click', item_checkbox, function( event ){

      $(this).closest(deletable).toggleClass('selected');

      if($(item_checkbox + ':checked').length) {
         $(delete_items_btn).removeClass('k-is-disabled').removeClass('disabled');
      } else {
         $(delete_items_btn).addClass('k-is-disabled').addClass('disabled');
      }
  });

  //delete item event handler
  $('body').on('click', delete_item_btn, function( event ){

      event.preventDefault();

      var elem = $(this).closest(deletable);

      if(confirm(request_prompt)) {
          console.log(elem);
          elem.KItemDelete();
      }
  });

  //delete items event handler
  $('body').on('click', delete_items_btn, function( event ){

      event.preventDefault();

      if (!$(this).hasClass('k-is-disabled'))
      {
          if (confirm(request_prompt)) {

              $.each($(item_checkbox + ':checked'), function (index, checkbox) {

                  var elem = $(checkbox).closest(deletable);

                  $(elem).KItemDelete();
              });

              $(delete_items_btn).addClass('k-is-disabled').addClass('disabled');
          }
      }
  });
});
